/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.api.mock;

import java.util.LinkedList;
import java.util.List;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;

public class SimpleDomainList
implements DomainList {
    private List<String> domains = new LinkedList<String>();

    public boolean containsDomain(String domain) throws DomainListException {
        return this.domains.contains(domain);
    }

    public String[] getDomains() throws DomainListException {
        return this.domains.toArray(new String[this.domains.size()]);
    }

    public void addDomain(String domain) throws DomainListException {
        if (this.domains.contains(domain)) {
            throw new DomainListException("Domain " + domain + " already exist");
        }
        this.domains.add(domain);
    }

    public void removeDomain(String domain) throws DomainListException {
        if (!this.domains.remove(domain)) {
            throw new DomainListException("Domain " + domain + " does not exist");
        }
    }

    public String getDefaultDomain() {
        return "localhost";
    }
}

