/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.logging.Log;
import org.apache.james.lifecycle.Configurable;
import org.apache.james.lifecycle.LifecycleUtil;
import org.apache.james.lifecycle.LogEnabled;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.mailetcontainer.api.MailProcessorList;
import org.apache.james.mailetcontainer.api.MailetContainer;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.services.SpoolManager;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamesSpoolManager
implements Runnable,
SpoolManager,
Configurable,
LogEnabled {
    private MailQueue queue;
    private int numThreads;
    private AtomicInteger numActive = new AtomicInteger(0);
    private AtomicBoolean active = new AtomicBoolean(false);
    private Collection<Thread> spoolThreads;
    private MailProcessorList mailProcessor;
    private Log logger;
    private MailQueueFactory queueFactory;

    @Resource(name="mailQueueFactory")
    public void setMailQueueFactory(MailQueueFactory queueFactory) {
        this.queueFactory = queueFactory;
    }

    @Resource(name="mailProcessor")
    public void setMailProcessorList(MailProcessorList mailProcessor) {
        this.mailProcessor = mailProcessor;
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.numThreads = config.getInt("threads", 100);
    }

    @PostConstruct
    public void init() throws Exception {
        this.logger.info((Object)"JamesSpoolManager init...");
        this.queue = this.queueFactory.getQueue("spool");
        if (this.logger.isInfoEnabled()) {
            StringBuffer infoBuffer = new StringBuffer(64).append("Spooler Manager uses ").append(this.numThreads).append(" Thread(s)");
            this.logger.info((Object)infoBuffer.toString());
        }
        this.active.set(true);
        this.spoolThreads = new ArrayList<Thread>(this.numThreads);
        for (int i = 0; i < this.numThreads; ++i) {
            Thread reader = new Thread((Runnable)this, "Spool Thread #" + i);
            this.spoolThreads.add(reader);
            reader.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Run JamesSpoolManager: " + Thread.currentThread().getName()));
            this.logger.info((Object)("Spool=" + this.queue.getClass().getName()));
        }
        while (this.active.get()) {
            this.numActive.incrementAndGet();
            try {
                MailQueue.MailQueueItem queueItem = this.queue.deQueue();
                Mail mail = queueItem.getMail();
                if (this.logger.isDebugEnabled()) {
                    StringBuffer debugBuffer = new StringBuffer(64).append("==== Begin processing mail ").append(mail.getName()).append("====");
                    this.logger.debug((Object)debugBuffer.toString());
                }
                try {
                    this.mailProcessor.service(mail);
                    queueItem.done(true);
                }
                catch (Exception e) {
                    if (this.active.get() && this.logger.isErrorEnabled()) {
                        this.logger.error((Object)("Exception processing mail in JamesSpoolManager.run " + e.getMessage()), (Throwable)e);
                    }
                    queueItem.done(false);
                }
                finally {
                    LifecycleUtil.dispose((Object)mail);
                    mail = null;
                }
            }
            catch (Throwable e) {
                if (!this.active.get() || !this.logger.isErrorEnabled()) continue;
                this.logger.error((Object)("Exception processing mail in JamesSpoolManager.run " + e.getMessage()), e);
            }
            finally {
                this.numActive.decrementAndGet();
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stop JamesSpoolManager: " + Thread.currentThread().getName()));
        }
    }

    @PreDestroy
    public void dispose() {
        this.logger.info((Object)"JamesSpoolManager dispose...");
        this.active.set(false);
        for (Thread thread : this.spoolThreads) {
            thread.interrupt();
        }
        long stop = System.currentTimeMillis() + 60000L;
        while (this.numActive.get() != 0 && stop > System.currentTimeMillis()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        this.logger.info((Object)"JamesSpoolManager thread shutdown completed.");
    }

    public String[] getProcessorNames() {
        return this.mailProcessor.getProcessorNames();
    }

    public List<Mailet> getMailets(String processorName) {
        MailetContainer mailetContainer = this.getMailetContainerByName(processorName);
        if (mailetContainer == null) {
            return new ArrayList<Mailet>();
        }
        return mailetContainer.getMailets();
    }

    public List<Matcher> getMatchers(String processorName) {
        MailetContainer mailetContainer = this.getMailetContainerByName(processorName);
        if (mailetContainer == null) {
            return new ArrayList<Matcher>();
        }
        return mailetContainer.getMatchers();
    }

    private MailetContainer getMailetContainerByName(String processorName) {
        MailProcessor processor = this.mailProcessor.getProcessor(processorName);
        if (!(processor instanceof MailetContainer)) {
            return null;
        }
        return (MailetContainer)processor;
    }

    public void setLog(Log log) {
        this.logger = log;
    }
}

