/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import java.net.UnknownHostException;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.mail.internet.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.logging.Log;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.lifecycle.Configurable;
import org.apache.james.lifecycle.LogEnabled;
import org.apache.james.services.MailServer;
import org.apache.mailet.MailAddress;

public class JamesMailServer
implements MailServer,
LogEnabled,
Configurable {
    private static final String SOFTWARE_NAME_VERSION = "Apache-James Mail Server 3.0-M1";
    private HierarchicalConfiguration conf = null;
    private static int count = 0;
    private static final Object countLock = new Object();
    private DomainList domains;
    private boolean virtualHosting = false;
    private String defaultDomain = null;
    private String helloName = null;
    private Log logger;
    private DNSService dns;
    private MailAddress postmaster;

    @Resource(name="domainlist")
    public void setDomainList(DomainList domains) {
        this.domains = domains;
    }

    @Resource(name="dnsservice")
    public void setDNSService(DNSService dns) {
        this.dns = dns;
    }

    public final void setLog(Log logger) {
        this.logger = logger;
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.conf = config;
    }

    @PostConstruct
    public void init() throws Exception {
        this.logger.info((Object)"JAMES init...");
        if (this.conf.getKeys("usernames").hasNext()) {
            throw new ConfigurationException("<usernames> parameter in James block was removed. Please configure this data in UsersRepository block");
        }
        if (this.conf.getKeys("servernames").hasNext()) {
            throw new ConfigurationException("<servernames> parameter in mailserver block was removed. Please configure this data in domainlist block");
        }
        this.initializeServernames();
        this.logger.info((Object)"Private Repository LocalInbox opened");
        this.virtualHosting = this.conf.getBoolean("enableVirtualHosting", false);
        this.logger.info((Object)("VirtualHosting supported: " + this.virtualHosting));
        this.defaultDomain = this.conf.getString("defaultDomain", null);
        if (this.defaultDomain == null && this.virtualHosting) {
            throw new ConfigurationException("Please configure a defaultDomain if using VirtualHosting");
        }
        this.logger.info((Object)("Defaultdomain: " + this.defaultDomain));
        if (this.conf.getKeys("helloName").hasNext()) {
            SubnodeConfiguration helloNameConfig = this.conf.configurationAt("helloName");
            boolean autodetect = helloNameConfig.getBoolean("[@autodetect]", true);
            if (autodetect) {
                try {
                    this.helloName = this.dns.getHostName(this.dns.getLocalHost());
                }
                catch (UnknownHostException e) {
                    this.helloName = "localhost";
                }
            } else {
                this.helloName = this.conf.getString("helloName", this.defaultDomain);
            }
        }
        this.initPostmaster();
        System.out.println(SOFTWARE_NAME_VERSION);
        this.logger.info((Object)"JAMES ...init end");
    }

    private void initializeServernames() throws ConfigurationException, ParseException {
        String defaultDomain = this.getDefaultDomain();
        if (!this.domains.containsDomain(defaultDomain)) {
            this.logger.warn((Object)"Configured defaultDomain not exist in DomainList, please add it ASAP!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId() {
        long localCount;
        Object object = countLock;
        synchronized (object) {
            localCount = count++;
        }
        StringBuffer idBuffer = new StringBuffer(64).append("Mail").append(System.currentTimeMillis()).append("-").append(localCount);
        return idBuffer.toString();
    }

    public boolean supportVirtualHosting() {
        return this.virtualHosting;
    }

    public String getDefaultDomain() {
        if (this.defaultDomain == null) {
            String[] domainList = this.domains.getDomains();
            if (domainList == null || domainList.length < 1) {
                return this.conf.getString("defaultDomain", "localhost");
            }
            return domainList[0];
        }
        return this.defaultDomain;
    }

    public String getHelloName() {
        if (this.helloName != null) {
            return this.helloName;
        }
        return this.getDefaultDomain();
    }

    private void initPostmaster() throws Exception {
        String postMasterAddress = this.conf.getString("postmaster", "postmaster").toLowerCase(Locale.US);
        if (postMasterAddress.indexOf(64) < 0) {
            String domainName = null;
            String[] doms = this.domains.getDomains();
            if (doms != null) {
                for (int i = 0; i < doms.length; ++i) {
                    String serverName = doms[i].toLowerCase(Locale.US);
                    if ("localhost".equals(serverName)) continue;
                    domainName = serverName;
                }
            }
            postMasterAddress = postMasterAddress + "@" + (domainName != null ? domainName : this.getDefaultDomain());
        }
        this.postmaster = new MailAddress(postMasterAddress);
        if (!this.domains.containsDomain(this.postmaster.getDomain())) {
            StringBuffer warnBuffer = new StringBuffer(320).append("The specified postmaster address ( ").append(this.postmaster).append(" ) is not a local address.  This is not necessarily a problem, but it does mean that emails addressed to the postmaster will be routed to another server.  For some configurations this may cause problems.");
            this.logger.warn((Object)warnBuffer.toString());
        }
    }

    public MailAddress getPostmaster() {
        return this.postmaster;
    }
}

