/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore;

import com.google.inject.Provider;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.james.blob.cassandra.CassandraBlobsDAO;
import org.apache.james.blob.objectstorage.ObjectStorageBlobsDAO;
import org.apache.james.blob.union.UnionBlobStore;
import org.apache.james.modules.blobstore.BlobStoreChoosingConfiguration;
import org.apache.james.modules.blobstore.BlobStoreChoosingModule;
import org.apache.james.modules.objectstorage.FakePropertiesProvider;
import org.apache.james.utils.PropertiesProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class BlobStoreChoosingModuleTest {
    private static CassandraBlobsDAO CASSANDRA_BLOBSTORE = (CassandraBlobsDAO)Mockito.mock(CassandraBlobsDAO.class);
    private static Provider<CassandraBlobsDAO> CASSANDRA_BLOBSTORE_PROVIDER = () -> CASSANDRA_BLOBSTORE;
    private static ObjectStorageBlobsDAO SWIFT_BLOBSTORE = (ObjectStorageBlobsDAO)Mockito.mock(ObjectStorageBlobsDAO.class);
    private static Provider<ObjectStorageBlobsDAO> SWIFT_BLOBSTORE_PROVIDER = () -> SWIFT_BLOBSTORE;

    BlobStoreChoosingModuleTest() {
    }

    @Test
    void provideChoosingConfigurationShouldThrowWhenMissingPropertyField() {
        BlobStoreChoosingModule module = new BlobStoreChoosingModule();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"");
        FakePropertiesProvider propertyProvider = FakePropertiesProvider.builder().register("blobstore", (Configuration)configuration).build();
        Assertions.assertThatThrownBy(() -> module.provideChoosingConfiguration((PropertiesProvider)propertyProvider)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void provideChoosingConfigurationShouldThrowWhenEmptyPropertyField() throws Exception {
        BlobStoreChoosingModule module = new BlobStoreChoosingModule();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"");
        FakePropertiesProvider propertyProvider = FakePropertiesProvider.builder().register("blobstore", (Configuration)configuration).build();
        Assertions.assertThatThrownBy(() -> module.provideChoosingConfiguration((PropertiesProvider)propertyProvider)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void provideChoosingConfigurationShouldThrowWhenPropertyFieldIsNotInSupportedList() throws Exception {
        BlobStoreChoosingModule module = new BlobStoreChoosingModule();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"gabouzomeuh");
        FakePropertiesProvider propertyProvider = FakePropertiesProvider.builder().register("blobstore", (Configuration)configuration).build();
        Assertions.assertThatThrownBy(() -> module.provideChoosingConfiguration((PropertiesProvider)propertyProvider)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void provideChoosingConfigurationShouldReturnCassandraWhenNoFile() throws Exception {
        BlobStoreChoosingModule module = new BlobStoreChoosingModule();
        FakePropertiesProvider propertyProvider = FakePropertiesProvider.builder().register("other_configuration_file", (Configuration)new PropertiesConfiguration()).build();
        Assertions.assertThat((Object)module.provideChoosingConfiguration((PropertiesProvider)propertyProvider)).isEqualTo((Object)BlobStoreChoosingConfiguration.cassandra());
    }

    @Test
    void provideChoosingConfigurationShouldReturnSwiftFactoryWhenConfigurationImplIsSwift() throws Exception {
        BlobStoreChoosingModule module = new BlobStoreChoosingModule();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)BlobStoreChoosingConfiguration.BlobStoreImplName.OBJECTSTORAGE.getName());
        FakePropertiesProvider propertyProvider = FakePropertiesProvider.builder().register("blobstore", (Configuration)configuration).build();
        Assertions.assertThat((Object)module.provideChoosingConfiguration((PropertiesProvider)propertyProvider)).isEqualTo((Object)BlobStoreChoosingConfiguration.objectStorage());
    }

    @Test
    void provideChoosingConfigurationShouldReturnUnionConfigurationWhenConfigurationImplIsUnion() throws Exception {
        BlobStoreChoosingModule module = new BlobStoreChoosingModule();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)BlobStoreChoosingConfiguration.BlobStoreImplName.UNION.getName());
        FakePropertiesProvider propertyProvider = FakePropertiesProvider.builder().register("blobstore", (Configuration)configuration).build();
        Assertions.assertThat((Object)module.provideChoosingConfiguration((PropertiesProvider)propertyProvider)).isEqualTo((Object)BlobStoreChoosingConfiguration.union());
    }

    @Test
    void provideChoosingConfigurationShouldReturnCassandraFactoryWhenConfigurationImplIsCassandra() throws Exception {
        BlobStoreChoosingModule module = new BlobStoreChoosingModule();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)BlobStoreChoosingConfiguration.BlobStoreImplName.CASSANDRA.getName());
        FakePropertiesProvider propertyProvider = FakePropertiesProvider.builder().register("blobstore", (Configuration)configuration).build();
        Assertions.assertThat((Object)module.provideChoosingConfiguration((PropertiesProvider)propertyProvider)).isEqualTo((Object)BlobStoreChoosingConfiguration.cassandra());
    }

    @Test
    void provideBlobStoreShouldReturnCassandraBlobStoreWhenCassandraConfigured() {
        BlobStoreChoosingModule module = new BlobStoreChoosingModule();
        Assertions.assertThat((Object)module.provideBlobStore(BlobStoreChoosingConfiguration.cassandra(), CASSANDRA_BLOBSTORE_PROVIDER, SWIFT_BLOBSTORE_PROVIDER)).isEqualTo((Object)CASSANDRA_BLOBSTORE);
    }

    @Test
    void provideBlobStoreShouldReturnSwiftBlobStoreWhenSwiftConfigured() {
        BlobStoreChoosingModule module = new BlobStoreChoosingModule();
        Assertions.assertThat((Object)module.provideBlobStore(BlobStoreChoosingConfiguration.cassandra(), CASSANDRA_BLOBSTORE_PROVIDER, SWIFT_BLOBSTORE_PROVIDER)).isEqualTo((Object)CASSANDRA_BLOBSTORE);
    }

    @Test
    void provideBlobStoreShouldReturnUnionBlobStoreWhenUnionConfigured() {
        BlobStoreChoosingModule module = new BlobStoreChoosingModule();
        Assertions.assertThat((Object)module.provideBlobStore(BlobStoreChoosingConfiguration.union(), CASSANDRA_BLOBSTORE_PROVIDER, SWIFT_BLOBSTORE_PROVIDER)).isInstanceOf(UnionBlobStore.class);
    }
}

