/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.james.modules.blobstore.BlobStoreChoosingConfiguration;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BlobStoreChoosingConfigurationTest {
    private static final String OBJECT_STORAGE = "objectstorage";
    private static final String CASSANDRA = "cassandra";
    private static final String UNION = "union";

    BlobStoreChoosingConfigurationTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(BlobStoreChoosingConfiguration.class).verify();
    }

    @Test
    void fromShouldThrowWhenBlobStoreImplIsMissing() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BlobStoreChoosingConfiguration.from((Configuration)configuration)).isInstanceOf(IllegalStateException.class)).hasMessage("implementation property is missing please use one of supported values in: cassandra, objectstorage, union");
    }

    @Test
    void fromShouldThrowWhenBlobStoreImplIsNull() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BlobStoreChoosingConfiguration.from((Configuration)configuration)).isInstanceOf(IllegalStateException.class)).hasMessage("implementation property is missing please use one of supported values in: cassandra, objectstorage, union");
    }

    @Test
    void fromShouldThrowWhenBlobStoreImplIsEmpty() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BlobStoreChoosingConfiguration.from((Configuration)configuration)).isInstanceOf(IllegalStateException.class)).hasMessage("implementation property is missing please use one of supported values in: cassandra, objectstorage, union");
    }

    @Test
    void fromShouldThrowWhenBlobStoreImplIsNotInSupportedList() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"un_supported");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BlobStoreChoosingConfiguration.from((Configuration)configuration)).isInstanceOf(IllegalArgumentException.class)).hasMessage("un_supported is not a valid name of BlobStores, please use one of supported values in: cassandra, objectstorage, union");
    }

    @Test
    void fromShouldReturnConfigurationWhenBlobStoreImplIsCassandra() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)CASSANDRA);
        Assertions.assertThat((String)BlobStoreChoosingConfiguration.from((Configuration)configuration).getImplementation().getName()).isEqualTo((Object)CASSANDRA);
    }

    @Test
    void fromShouldReturnConfigurationWhenBlobStoreImplIsUnion() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)UNION);
        Assertions.assertThat((String)BlobStoreChoosingConfiguration.from((Configuration)configuration).getImplementation().getName()).isEqualTo((Object)UNION);
    }

    @Test
    void fromShouldReturnConfigurationWhenBlobStoreImplIsSwift() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)OBJECT_STORAGE);
        Assertions.assertThat((String)BlobStoreChoosingConfiguration.from((Configuration)configuration).getImplementation().getName()).isEqualTo((Object)OBJECT_STORAGE);
    }

    @Test
    void fromShouldReturnConfigurationWhenBlobStoreImplIsSupportedAndCaseInsensitive() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"OBjecTStorAGE");
        Assertions.assertThat((String)BlobStoreChoosingConfiguration.from((Configuration)configuration).getImplementation().getName()).isEqualTo((Object)OBJECT_STORAGE);
    }

    @Test
    void fromShouldReturnConfigurationWhenBlobStoreImplIsSupportedAndHasExtraSpaces() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)" cassandra ");
        Assertions.assertThat((String)BlobStoreChoosingConfiguration.from((Configuration)configuration).getImplementation().getName()).isEqualTo((Object)CASSANDRA);
    }
}

