/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import java.net.URISyntaxException;
import java.time.Duration;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.james.CleanupTasksPerformer;
import org.apache.james.backend.rabbitmq.DockerRabbitMQ;
import org.apache.james.backend.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backend.rabbitmq.RabbitMQFixture;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueueManagement;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import org.apache.james.task.Task;

public class TestRabbitMQModule
extends AbstractModule {
    private final DockerRabbitMQ rabbitMQ;

    public TestRabbitMQModule(DockerRabbitMQ rabbitMQ) {
        this.rabbitMQ = rabbitMQ;
    }

    protected void configure() {
        this.bind(CassandraMailQueueViewConfiguration.class).toInstance((Object)CassandraMailQueueViewConfiguration.builder().bucketCount(1).updateBrowseStartPace(1000).sliceWindow(Duration.ofHours(1L)).build());
        Multibinder.newSetBinder((Binder)this.binder(), CleanupTasksPerformer.CleanupTask.class).addBinding().to(QueueCleanUp.class);
    }

    @Provides
    @Singleton
    protected RabbitMQConfiguration provideRabbitMQConfiguration() throws URISyntaxException {
        return RabbitMQConfiguration.builder().amqpUri(this.rabbitMQ.amqpUri()).managementUri(this.rabbitMQ.managementUri()).managementCredentials(RabbitMQFixture.DEFAULT_MANAGEMENT_CREDENTIAL).build();
    }

    public static class QueueCleanUp
    implements CleanupTasksPerformer.CleanupTask {
        private final RabbitMQMailQueueManagement api;

        @Inject
        public QueueCleanUp(RabbitMQMailQueueManagement api) {
            this.api = api;
        }

        public Task.Result run() {
            this.api.deleteAllQueues();
            return Task.Result.COMPLETED;
        }
    }
}

