/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import java.io.IOException;
import org.apache.james.AggregateGuiceModuleTestRule;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.CleanupTasksPerformer;
import org.apache.james.EmbeddedElasticSearchRule;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestRule;
import org.apache.james.TempFilesystemTestRule;
import org.apache.james.backend.rabbitmq.DockerRabbitMQSingleton;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.store.search.PDFTextExtractor;
import org.apache.james.modules.TestESMetricReporterModule;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.modules.TestRabbitMQModule;
import org.apache.james.modules.TestSwiftBlobStoreModule;
import org.apache.james.server.core.configuration.Configuration;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CassandraRabbitMQSwiftJmapTestRule
implements TestRule {
    private static final int LIMIT_TO_10_MESSAGES = 10;
    public static final int TWO_SECONDS = 2000;
    private final TemporaryFolder temporaryFolder;
    private final GuiceModuleTestRule guiceModuleTestRule;

    public static CassandraRabbitMQSwiftJmapTestRule defaultTestRule() {
        return new CassandraRabbitMQSwiftJmapTestRule(new GuiceModuleTestRule[]{new EmbeddedElasticSearchRule()});
    }

    public CassandraRabbitMQSwiftJmapTestRule(GuiceModuleTestRule ... guiceModuleTestRule) {
        TempFilesystemTestRule tempFilesystemTestRule = new TempFilesystemTestRule();
        this.temporaryFolder = tempFilesystemTestRule.getTemporaryFolder();
        this.guiceModuleTestRule = AggregateGuiceModuleTestRule.of((GuiceModuleTestRule[])guiceModuleTestRule).aggregate(new GuiceModuleTestRule[]{tempFilesystemTestRule});
    }

    public GuiceJamesServer jmapServer(Module ... additionals) throws IOException {
        Configuration configuration = Configuration.builder().workingDirectory(this.temporaryFolder.newFolder()).configurationFromClasspath().build();
        return GuiceJamesServer.forConfiguration((Configuration)configuration).combineWith(new Module[]{CassandraRabbitMQJamesServerMain.MODULES}).overrideWith(new Module[]{binder -> binder.bind(TextExtractor.class).to(PDFTextExtractor.class)}).overrideWith(new Module[]{new TestRabbitMQModule(DockerRabbitMQSingleton.SINGLETON)}).overrideWith(new Module[]{new TestSwiftBlobStoreModule()}).overrideWith(new Module[]{new TestJMAPServerModule(10L)}).overrideWith(new Module[]{new TestESMetricReporterModule()}).overrideWith(new Module[]{this.guiceModuleTestRule.getModule()}).overrideWith(new Module[]{binder -> binder.bind(CleanupTasksPerformer.class).asEagerSingleton()}).overrideWith(additionals);
    }

    public Statement apply(Statement base, Description description) {
        return this.guiceModuleTestRule.apply(base, description);
    }

    public void await() {
        this.awaitProcessingStart();
        this.guiceModuleTestRule.await();
    }

    private void awaitProcessingStart() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

