/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.EmbeddedElasticSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerContract;
import org.apache.james.JamesServerExtension;
import org.apache.james.JamesServerExtensionBuilder;
import org.apache.james.JmapJamesServerContract;
import org.apache.james.blob.objectstorage.AESPayloadCodec;
import org.apache.james.blob.objectstorage.DefaultPayloadCodec;
import org.apache.james.blob.objectstorage.PayloadCodec;
import org.apache.james.core.Domain;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.SwiftBlobStoreExtension;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.modules.objectstorage.PayloadCodecFactory;
import org.apache.james.modules.objectstorage.guice.DockerSwiftTestRule;
import org.apache.james.modules.protocols.ImapGuiceProbe;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.IMAPMessageReader;
import org.apache.james.utils.SMTPMessageSender;
import org.apache.james.utils.SpoolerProbe;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Duration;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.RegisterExtension;

class CassandraRabbitMQJamesServerTest {
    private static final String DOMAIN = "domain";
    private static final String JAMES_USER = "james-user@domain";
    private static final String PASSWORD = "secret";
    private static final int LIMIT_TO_10_MESSAGES = 10;
    private static final ConditionFactory CALMLY_AWAIT = Awaitility.with().pollInterval(Duration.ONE_HUNDRED_MILLISECONDS).and().pollDelay(Duration.ONE_HUNDRED_MILLISECONDS).await();
    private static final JamesServerExtensionBuilder.ServerProvider CONFIGURATION_BUILDER = configuration -> GuiceJamesServer.forConfiguration((Configuration)configuration).combineWith(new Module[]{CassandraRabbitMQJamesServerMain.MODULES}).overrideWith(new Module[]{new TestJMAPServerModule(10L)}).overrideWith(new Module[]{JmapJamesServerContract.DOMAIN_LIST_CONFIGURATION_MODULE});

    CassandraRabbitMQJamesServerTest() {
    }

    private static JamesServerExtensionBuilder baseExtensionBuilder() {
        return new JamesServerExtensionBuilder().extension((GuiceModuleTestExtension)new EmbeddedElasticSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new RabbitMQExtension()).server(CONFIGURATION_BUILDER);
    }

    static /* synthetic */ JamesServerExtensionBuilder.ServerProvider access$100() {
        return CONFIGURATION_BUILDER;
    }

    static /* synthetic */ JamesServerExtensionBuilder access$200() {
        return CassandraRabbitMQJamesServerTest.baseExtensionBuilder();
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
    class WithoutSwift
    implements ContractSuite {
        @RegisterExtension
        JamesServerExtension testExtension = CassandraRabbitMQJamesServerTest.access$200().build();

        WithoutSwift() {
        }
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
    class WithDefaultSwift
    implements ContractSuite {
        @RegisterExtension
        JamesServerExtension testExtension = CassandraRabbitMQJamesServerTest.access$200().extension((GuiceModuleTestExtension)new SwiftBlobStoreExtension()).build();

        WithDefaultSwift() {
        }

        @Test
        void defaultPayloadShouldBeByDefault(GuiceJamesServer jamesServer) {
            PayloadCodec payloadCodec = ((DockerSwiftTestRule.TestSwiftBlobStoreProbe)jamesServer.getProbe(DockerSwiftTestRule.TestSwiftBlobStoreProbe.class)).getSwiftPayloadCodec();
            Assertions.assertThat((Object)payloadCodec).isInstanceOf(DefaultPayloadCodec.class);
        }
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
    class WithEncryptedSwift
    implements ContractSuite {
        @RegisterExtension
        JamesServerExtension testExtension = CassandraRabbitMQJamesServerTest.access$200().extension((GuiceModuleTestExtension)new SwiftBlobStoreExtension(PayloadCodecFactory.AES256)).server(CassandraRabbitMQJamesServerTest.access$100()).build();

        WithEncryptedSwift() {
        }

        @Test
        void encryptedPayloadShouldBeConfiguredWhenProvidingEncryptedPayloadConfiguration(GuiceJamesServer jamesServer) {
            PayloadCodec payloadCodec = ((DockerSwiftTestRule.TestSwiftBlobStoreProbe)jamesServer.getProbe(DockerSwiftTestRule.TestSwiftBlobStoreProbe.class)).getSwiftPayloadCodec();
            Assertions.assertThat((Object)payloadCodec).isInstanceOf(AESPayloadCodec.class);
        }
    }

    static interface ContractSuite
    extends JmapJamesServerContract,
    MailsShouldBeWellReceived,
    JamesServerContract {
    }

    static interface MailsShouldBeWellReceived {
        public static final String JAMES_SERVER_HOST = "127.0.0.1";

        @Test
        default public void mailsShouldBeWellReceived(GuiceJamesServer server) throws Exception {
            ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(CassandraRabbitMQJamesServerTest.DOMAIN).addUser(CassandraRabbitMQJamesServerTest.JAMES_USER, CassandraRabbitMQJamesServerTest.PASSWORD);
            try (SMTPMessageSender sender = new SMTPMessageSender(Domain.LOCALHOST.asString());){
                sender.connect(JAMES_SERVER_HOST, ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).sendMessage("bob@any.com", CassandraRabbitMQJamesServerTest.JAMES_USER);
            }
            CALMLY_AWAIT.until(() -> ((SpoolerProbe)server.getProbe(SpoolerProbe.class)).processingFinished());
            var3_3 = null;
            try (IMAPMessageReader reader = new IMAPMessageReader();){
                reader.connect(JAMES_SERVER_HOST, ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(CassandraRabbitMQJamesServerTest.JAMES_USER, CassandraRabbitMQJamesServerTest.PASSWORD).select("INBOX").awaitMessage(CALMLY_AWAIT);
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
        }
    }
}

