/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.GuiceModuleTestRule;
import org.apache.james.user.ldap.DockerLdapSingleton;
import org.apache.james.user.ldap.LdapRepositoryConfiguration;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DockerLdapRule
implements GuiceModuleTestRule {
    public Module getModule() {
        return binder -> binder.bind(LdapRepositoryConfiguration.class).toInstance((Object)this.computeConfiguration(DockerLdapSingleton.ldapContainer.getLdapHost()));
    }

    public Statement apply(Statement statement, Description description) {
        return statement;
    }

    private LdapRepositoryConfiguration computeConfiguration(String ldapIp) {
        try {
            return LdapRepositoryConfiguration.builder().ldapHost(ldapIp).principal("cn=admin,dc=james,dc=org").credentials("mysecretpassword").userBase("ou=People,dc=james,dc=org").userIdAttribute("uid").userObjectClass("inetOrgPerson").maxRetries(4).retryStartInterval(0L).retryMaxInterval(8L).scale(1000).build();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        DockerLdapSingleton.ldapContainer.start();
    }

    public void stop() {
        DockerLdapSingleton.ldapContainer.stop();
    }
}

