/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import org.apache.commons.net.imap.IMAPClient;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraLdapJamesServerMain;
import org.apache.james.DockerElasticSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerContract;
import org.apache.james.JamesServerExtension;
import org.apache.james.LdapTestExtension;
import org.apache.james.core.Domain;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.modules.protocols.ImapGuiceProbe;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.user.ldap.DockerLdapSingleton;
import org.apache.james.utils.IMAPMessageReader;
import org.apache.james.utils.SMTPMessageSender;
import org.apache.james.utils.SpoolerProbe;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Duration;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class CassandraLdapJamesServerTest
implements JamesServerContract {
    private static Duration slowPacedPollInterval = Duration.ONE_HUNDRED_MILLISECONDS;
    private static ConditionFactory calmlyAwait = Awaitility.with().pollInterval(slowPacedPollInterval).and().with().pollDelay(slowPacedPollInterval).await();
    private IMAPClient imapClient = new IMAPClient();
    @RegisterExtension
    IMAPMessageReader imapMessageReader = new IMAPMessageReader();
    SMTPMessageSender messageSender = new SMTPMessageSender(Domain.LOCALHOST.asString());
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder().extension((GuiceModuleTestExtension)new DockerElasticSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new LdapTestExtension()).server(configuration -> GuiceJamesServer.forConfiguration((Configuration)configuration).combineWith(new Module[]{CassandraLdapJamesServerMain.MODULES}).overrideWith(new Module[]{TestJMAPServerModule.limitToTenMessages()}).overrideWith(new Module[]{DOMAIN_LIST_CONFIGURATION_MODULE})).build();

    CassandraLdapJamesServerTest() {
    }

    @Test
    void userFromLdapShouldLoginViaImapProtocol(GuiceJamesServer server) throws Exception {
        this.imapClient.connect("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort());
        Assertions.assertThat((boolean)this.imapClient.login(DockerLdapSingleton.JAMES_USER.asString(), "secret")).isTrue();
    }

    @Test
    void mailsShouldBeWellReceivedBeforeFirstUserConnectionWithLdap(GuiceJamesServer server) throws Exception {
        this.messageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).sendMessage("bob@any.com", DockerLdapSingleton.JAMES_USER.asString() + "@localhost");
        calmlyAwait.until(() -> ((SpoolerProbe)server.getProbe(SpoolerProbe.class)).processingFinished());
        this.imapMessageReader.connect("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(DockerLdapSingleton.JAMES_USER, "secret").select("INBOX").awaitMessage(calmlyAwait);
    }
}

