/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing.eventstore;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.TestAggregateId;
import org.apache.james.eventsourcing.TestEvent;
import org.apache.james.eventsourcing.eventstore.EventStoreFailedException;
import org.apache.james.eventsourcing.eventstore.History;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class HistoryTest {
    HistoryTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(History.class).verify();
    }

    @Test
    void emptyShouldGenerateAnEmptyHistory() {
        Assertions.assertThat((Object)History.empty()).isEqualTo((Object)History.of((Event[])new Event[0]));
    }

    @Test
    void getVersionShouldReturnEmptyWhenEmpty() {
        Assertions.assertThat((Optional)History.empty().getVersion()).isEmpty();
    }

    @Test
    void getVersionShouldReturnSingleEventIdWhenSingleEvent() {
        Assertions.assertThat((Optional)History.of((Event[])new Event[]{new TestEvent(EventId.first(), TestAggregateId.testId((int)42), "any")}).getVersion()).contains((Object)EventId.first());
    }

    @Test
    void getVersionShouldReturnHighestEventId() {
        TestEvent event1 = new TestEvent(EventId.first(), TestAggregateId.testId((int)42), "any");
        TestEvent event2 = new TestEvent(event1.eventId().next(), TestAggregateId.testId((int)42), "any");
        Assertions.assertThat((Optional)History.of((Event[])new Event[]{event1, event2}).getVersion()).contains((Object)event2.eventId());
    }

    @Test
    void duplicateHistoryShouldThrow() {
        TestEvent event1 = new TestEvent(EventId.first(), TestAggregateId.testId((int)42), "any");
        TestEvent event2 = new TestEvent(EventId.first(), TestAggregateId.testId((int)42), "any");
        Assertions.assertThatThrownBy(() -> History.of((Event[])new Event[]{event1, event2})).isInstanceOf(EventStoreFailedException.class);
    }
}

