/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing.eventstore;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.TestAggregateId;
import org.apache.james.eventsourcing.TestEvent;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.EventStoreFailedException;
import org.apache.james.eventsourcing.eventstore.History;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public interface EventStoreTest {
    public static final TestAggregateId AGGREGATE_1 = TestAggregateId.testId((int)1);
    public static final TestAggregateId AGGREGATE_2 = TestAggregateId.testId((int)2);

    @Test
    default public void getEventsOfAggregateShouldThrowOnNullAggregateId(EventStore testee) {
        Assertions.assertThatThrownBy(() -> testee.getEventsOfAggregate(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    default public void appendShouldThrowWhenEventFromSeveralAggregates(EventStore testee) {
        TestEvent event1 = new TestEvent(EventId.first(), AGGREGATE_1, "first");
        TestEvent event2 = new TestEvent(event1.eventId().next(), AGGREGATE_2, "second");
        Assertions.assertThatThrownBy(() -> testee.appendAll(new Event[]{event1, event2})).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    default public void appendShouldDoNothingOnEmptyEventList(EventStore testee) {
        Assertions.assertThatCode(() -> testee.appendAll(new Event[0])).doesNotThrowAnyException();
    }

    @Test
    default public void appendShouldThrowWhenTryingToRewriteHistory(EventStore testee) {
        TestEvent event1 = new TestEvent(EventId.first(), AGGREGATE_1, "first");
        testee.append((Event)event1);
        TestEvent event2 = new TestEvent(EventId.first(), AGGREGATE_1, "second");
        Assertions.assertThatThrownBy(() -> testee.append((Event)event2)).isInstanceOf(EventStoreFailedException.class);
    }

    @Test
    default public void getEventsOfAggregateShouldReturnEmptyHistoryWhenUnknown(EventStore testee) {
        Assertions.assertThat((Object)testee.getEventsOfAggregate((AggregateId)AGGREGATE_1)).isEqualTo((Object)History.empty());
    }

    @Test
    default public void getEventsOfAggregateShouldReturnAppendedEvent(EventStore testee) {
        TestEvent event = new TestEvent(EventId.first(), AGGREGATE_1, "first");
        testee.append((Event)event);
        Assertions.assertThat((Object)testee.getEventsOfAggregate((AggregateId)AGGREGATE_1)).isEqualTo((Object)History.of((List)ImmutableList.of((Object)event)));
    }

    @Test
    default public void getEventsOfAggregateShouldReturnAppendedEvents(EventStore testee) {
        TestEvent event1 = new TestEvent(EventId.first(), AGGREGATE_1, "first");
        TestEvent event2 = new TestEvent(event1.eventId().next(), AGGREGATE_1, "second");
        testee.append((Event)event1);
        testee.append((Event)event2);
        Assertions.assertThat((Object)testee.getEventsOfAggregate((AggregateId)AGGREGATE_1)).isEqualTo((Object)History.of((List)ImmutableList.of((Object)event1, (Object)event2)));
    }
}

