/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.Group;
import org.apache.james.mailbox.events.GenericGroup;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class GroupTest {
    GroupTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(Group.class).usingGetClass().verify();
    }

    @Test
    void equalsShouldReturnTrueOnSameClass() {
        Assertions.assertThat((Object)((Object)new GroupA())).isEqualTo((Object)new GroupA());
    }

    @Test
    void equalsShouldReturnFalseOnDifferentClass() {
        Assertions.assertThat((Object)((Object)new GroupA())).isNotEqualTo((Object)new GroupB());
    }

    @Test
    void equalsShouldReturnFalseOnSubClass() {
        Assertions.assertThat((Object)((Object)new GroupA())).isNotEqualTo((Object)new GroupC());
    }

    @Test
    void equalsShouldReturnFalseOnParentClass() {
        Assertions.assertThat((Object)((Object)new GroupC())).isNotEqualTo((Object)new GroupA());
    }

    @Test
    void genericGroupShouldMatchBeanContract() {
        EqualsVerifier.forClass(GenericGroup.class).withRedefinedSuperclass().verify();
    }

    @Test
    void asStringShouldReturnFqdnByDefault() {
        Assertions.assertThat((String)new EventBusTestFixture.GroupA().asString()).isEqualTo("org.apache.james.events.EventBusTestFixture$GroupA");
    }

    @Test
    void asStringShouldReturnNameWhenGenericGroup() {
        Assertions.assertThat((String)new GenericGroup("abc").asString()).isEqualTo("org.apache.james.mailbox.events.GenericGroup-abc");
    }

    @Test
    void deserializeShouldReturnGroupWhenGenericGroup() throws Exception {
        Assertions.assertThat((Object)Group.deserialize((String)"org.apache.james.mailbox.events.GenericGroup-abc")).isEqualTo((Object)new GenericGroup("abc"));
    }

    @Test
    void deserializeShouldReturnGroupWhenEmptyGenericGroup() throws Exception {
        Assertions.assertThat((Object)Group.deserialize((String)"org.apache.james.mailbox.events.GenericGroup-")).isEqualTo((Object)new GenericGroup(""));
    }

    @Test
    void deserializeShouldReturnGroupWhenExtendsGroup() throws Exception {
        Assertions.assertThat((Object)Group.deserialize((String)"org.apache.james.events.EventBusTestFixture$GroupA")).isEqualTo((Object)new EventBusTestFixture.GroupA());
    }

    @Test
    void deserializeShouldThrowWhenClassNotFound() {
        Assertions.assertThatThrownBy(() -> Group.deserialize((String)"org.apache.james.events.Noone")).isInstanceOf(Group.GroupDeserializationException.class);
    }

    @Test
    void deserializeShouldThrowWhenNotAGroup() {
        Assertions.assertThatThrownBy(() -> Group.deserialize((String)"java.lang.String")).isInstanceOf(Group.GroupDeserializationException.class);
    }

    @Test
    void deserializeShouldThrowWhenConstructorArgumentsRequired() {
        Assertions.assertThatThrownBy(() -> Group.deserialize((String)"org.apache.james.mailbox.events.GenericGroup")).isInstanceOf(Group.GroupDeserializationException.class);
    }

    @Test
    void deserializeShouldThrowWhenNull() {
        Assertions.assertThatThrownBy(() -> Group.deserialize(null)).isInstanceOf(Group.GroupDeserializationException.class);
    }

    @Test
    void deserializeShouldThrowWhenEmpty() {
        Assertions.assertThatThrownBy(() -> Group.deserialize((String)"")).isInstanceOf(Group.GroupDeserializationException.class);
    }

    static class GroupC
    extends GroupA {
        GroupC() {
        }
    }

    static class GroupB
    extends Group {
        GroupB() {
        }
    }

    static class GroupA
    extends Group {
        GroupA() {
        }
    }
}

