/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import org.apache.james.events.DispatchingFailureGroup;
import org.apache.james.events.EventBusName;
import org.apache.james.events.Group;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DispatchingFailureGroupTest {
    @Test
    void asStringShouldReturnEventBusName() {
        Assertions.assertThat((String)new DispatchingFailureGroup(new EventBusName("abc")).asString()).isEqualTo("org.apache.james.events.DispatchingFailureGroup-abc");
    }

    @Test
    void groupDeserializeShouldReturnGroupWhenValidInput() throws Group.GroupDeserializationException {
        Assertions.assertThat((Object)Group.deserialize((String)"org.apache.james.events.DispatchingFailureGroup-abc")).isEqualTo((Object)new DispatchingFailureGroup(new EventBusName("abc")));
    }

    @Test
    void deserializeShouldThrowWhenMissingDelimiter() {
        Assertions.assertThatThrownBy(() -> Group.deserialize((String)DispatchingFailureGroup.class.getName())).isInstanceOf(Group.GroupDeserializationException.class);
    }
}

