/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import java.time.Duration;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.events.RetryBackoffConfiguration;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

class RetryBackoffConfigurationTest {
    RetryBackoffConfigurationTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(RetryBackoffConfiguration.class).verify();
    }

    @Test
    void buildShouldThrowWhenNegativeFirstBackoff() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> RetryBackoffConfiguration.builder().maxRetries(8).firstBackoff(Duration.ofMillis(-1000L)).jitterFactor(0.5).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("firstBackoff is not allowed to be negative");
    }

    @Test
    void buildShouldThrowWhenNegativeMaxRetries() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> RetryBackoffConfiguration.builder().maxRetries(-6).firstBackoff(RetryBackoffConfiguration.DEFAULT_FIRST_BACKOFF).jitterFactor(0.5).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("maxRetries is not allowed to be negative");
    }

    @Test
    void buildShouldThrowWhenNegativeJitterFactor() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> RetryBackoffConfiguration.builder().maxRetries(8).firstBackoff(RetryBackoffConfiguration.DEFAULT_FIRST_BACKOFF).jitterFactor(-2.5).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("jitterFactor is not allowed to be negative or greater than 1");
    }

    @Test
    void buildShouldThrowWhenGreaterThanOneJitterFactor() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> RetryBackoffConfiguration.builder().maxRetries(8).firstBackoff(RetryBackoffConfiguration.DEFAULT_FIRST_BACKOFF).jitterFactor(1.000001).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("jitterFactor is not allowed to be negative or greater than 1");
    }

    @Test
    void buildShouldSuccessWhenZeroFirstBackoff() {
        RetryBackoffConfiguration retryBackoff = RetryBackoffConfiguration.builder().maxRetries(8).firstBackoff(Duration.ZERO).jitterFactor(0.5).build();
        Assertions.assertThat((long)retryBackoff.getFirstBackoff().toMillis()).isEqualTo(0L);
    }

    @Test
    void buildShouldSuccessWhenZeroMaxRetries() {
        RetryBackoffConfiguration retryBackoff = RetryBackoffConfiguration.builder().maxRetries(0).firstBackoff(RetryBackoffConfiguration.DEFAULT_FIRST_BACKOFF).jitterFactor(0.5).build();
        Assertions.assertThat((int)retryBackoff.getMaxRetries()).isEqualTo(0L);
    }

    @Test
    void buildShouldSuccessWhenZeroJitterFactor() {
        RetryBackoffConfiguration retryBackoff = RetryBackoffConfiguration.builder().maxRetries(8).firstBackoff(RetryBackoffConfiguration.DEFAULT_FIRST_BACKOFF).jitterFactor(0.0).build();
        Assertions.assertThat((double)retryBackoff.getJitterFactor()).isEqualTo(0.0);
    }

    @Test
    void buildShouldReturnCorrespondingValues() {
        RetryBackoffConfiguration retryBackoff = RetryBackoffConfiguration.builder().maxRetries(5).firstBackoff(Duration.ofMillis(200L)).jitterFactor(0.6).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(retryBackoff.getJitterFactor()).isEqualTo(0.6);
            softly.assertThat(retryBackoff.getMaxRetries()).isEqualTo(5);
            softly.assertThat(retryBackoff.getFirstBackoff()).isEqualTo((Object)Duration.ofMillis(200L));
        });
    }
}

