/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import java.util.UUID;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.events.EventDeadLetters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class InsertionIdTest {
    private static final UUID UUID_1 = UUID.fromString("6e0dd59d-660e-4d9b-b22f-0354479f47b4");

    InsertionIdTest() {
    }

    @Test
    void eventIdShouldMatchBeanContract() {
        EqualsVerifier.forClass(EventDeadLetters.InsertionId.class).verify();
    }

    @Test
    void ofShouldDeserializeUUIDs() {
        Assertions.assertThat((Object)EventDeadLetters.InsertionId.of((String)UUID_1.toString())).isEqualTo((Object)EventDeadLetters.InsertionId.of((UUID)UUID_1));
    }

    @Test
    void ofStringShouldThrowOnNullValue() {
        Assertions.assertThatThrownBy(() -> EventDeadLetters.InsertionId.of((String)null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void ofUuidShouldThrowOnNullValue() {
        Assertions.assertThatThrownBy(() -> EventDeadLetters.InsertionId.of((UUID)null)).isInstanceOf(NullPointerException.class);
    }
}

