/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import org.apache.james.core.Username;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.events.Event;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventDeadLettersHealthCheck;
import org.apache.james.events.Group;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

interface EventDeadLettersHealthCheckContract {
    public static final ComponentName COMPONENT_NAME = new ComponentName("EventDeadLettersHealthCheck");
    public static final String EXPECTED_DEGRADED_MESSAGE = "EventDeadLetters contain events. This might indicate transient failure on event processing.";
    public static final Username USERNAME = Username.of((String)"user");
    public static final Event.EventId EVENT_ID_1 = Event.EventId.of((String)"6e0dd59d-660e-4d9b-b22f-0354479f47b4");
    public static final Event.EventId EVENT_ID_2 = Event.EventId.of((String)"6e0dd59d-660e-4d9b-b22f-0354479f47b5");
    public static final Event EVENT_1 = new EventBusTestFixture.TestEvent(EVENT_ID_1, USERNAME);
    public static final Event EVENT_2 = new EventBusTestFixture.TestEvent(EVENT_ID_2, USERNAME);
    public static final Group GROUP_A = new EventBusTestFixture.GroupA();
    public static final Group GROUP_B = new EventBusTestFixture.GroupB();

    public EventDeadLettersHealthCheck testee();

    public EventDeadLetters eventDeadLetters();

    public void createErrorWhenDoingHealthCheck();

    public void resolveErrorWhenDoingHealthCheck();

    @Test
    default public void checkShouldReturnHealthyWhenEventDeadLetterEmpty() {
        Assertions.assertThat((boolean)((Result)this.testee().check().block()).isHealthy()).isTrue();
        Assertions.assertThat((Object)((Result)this.testee().check().block())).isEqualTo((Object)Result.healthy((ComponentName)COMPONENT_NAME));
    }

    @Test
    default public void checkShouldReturnDegradedWhenEventDeadLetterContainEvent() {
        this.eventDeadLetters().store(GROUP_A, EVENT_1).block();
        Assertions.assertThat((boolean)((Result)this.testee().check().block()).isDegraded()).isTrue();
        Assertions.assertThat((Object)((Result)this.testee().check().block())).isEqualTo((Object)Result.degraded((ComponentName)COMPONENT_NAME, (String)EXPECTED_DEGRADED_MESSAGE));
    }

    @Test
    default public void checkShouldReturnDegradedWhenEventDeadLetterContainEvents() {
        this.eventDeadLetters().store(GROUP_A, EVENT_1).block();
        this.eventDeadLetters().store(GROUP_B, EVENT_2).block();
        Assertions.assertThat((boolean)((Result)this.testee().check().block()).isDegraded()).isTrue();
        Assertions.assertThat((Object)((Result)this.testee().check().block())).isEqualTo((Object)Result.degraded((ComponentName)COMPONENT_NAME, (String)EXPECTED_DEGRADED_MESSAGE));
    }

    @Test
    default public void checkShouldReturnHealthyWhenRemovedAllEventDeadLetters() {
        EventDeadLetters.InsertionId insertionId1 = (EventDeadLetters.InsertionId)this.eventDeadLetters().store(GROUP_A, EVENT_1).block();
        EventDeadLetters.InsertionId insertionId2 = (EventDeadLetters.InsertionId)this.eventDeadLetters().store(GROUP_B, EVENT_2).block();
        Assertions.assertThat((boolean)((Result)this.testee().check().block()).isDegraded()).isTrue();
        Assertions.assertThat((Object)((Result)this.testee().check().block())).isEqualTo((Object)Result.degraded((ComponentName)COMPONENT_NAME, (String)EXPECTED_DEGRADED_MESSAGE));
        this.eventDeadLetters().remove(GROUP_A, insertionId1).block();
        this.eventDeadLetters().remove(GROUP_B, insertionId2).block();
        Assertions.assertThat((boolean)((Result)this.testee().check().block()).isHealthy()).isTrue();
        Assertions.assertThat((Object)((Result)this.testee().check().block())).isEqualTo((Object)Result.healthy((ComponentName)COMPONENT_NAME));
    }

    @Test
    default public void checkShouldReturnDegradedWhenRemovedSomeEventDeadLetters() {
        EventDeadLetters.InsertionId insertionId1 = (EventDeadLetters.InsertionId)this.eventDeadLetters().store(GROUP_A, EVENT_1).block();
        this.eventDeadLetters().store(GROUP_B, EVENT_2).block();
        Assertions.assertThat((boolean)((Result)this.testee().check().block()).isDegraded()).isTrue();
        Assertions.assertThat((Object)((Result)this.testee().check().block())).isEqualTo((Object)Result.degraded((ComponentName)COMPONENT_NAME, (String)EXPECTED_DEGRADED_MESSAGE));
        this.eventDeadLetters().remove(GROUP_A, insertionId1).block();
        Assertions.assertThat((boolean)((Result)this.testee().check().block()).isDegraded()).isTrue();
        Assertions.assertThat((Object)((Result)this.testee().check().block())).isEqualTo((Object)Result.degraded((ComponentName)COMPONENT_NAME, (String)EXPECTED_DEGRADED_MESSAGE));
    }

    @Test
    default public void checkShouldReturnUnHealthyWhenEventDeadLetterError() {
        Result actualResult;
        try {
            this.createErrorWhenDoingHealthCheck();
            actualResult = (Result)this.testee().check().block();
        }
        finally {
            this.resolveErrorWhenDoingHealthCheck();
        }
        Assertions.assertThat((boolean)actualResult.isUnHealthy()).isTrue();
    }
}

