/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import java.time.Duration;
import org.apache.james.events.EventBus;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;

public interface EventBusContract {
    public EnvironmentSpeedProfile getSpeedProfile();

    public EventBus eventBus();

    public static interface MultipleEventBusContract
    extends EventBusContract {
        public EventBus eventBus2();
    }

    public static enum EnvironmentSpeedProfile {
        SLOW(Duration.ofSeconds(2L), Duration.ofSeconds(10L)),
        FAST(Duration.ofMillis(200L), Duration.ofSeconds(5L));

        private final Duration shortWaitTime;
        private final Duration longWaitTime;

        private EnvironmentSpeedProfile(Duration shortWaitTime, Duration longWaitTime) {
            this.shortWaitTime = shortWaitTime;
            this.longWaitTime = longWaitTime;
        }

        public Duration getShortWaitTime() {
            return this.shortWaitTime;
        }

        public Duration getLongWaitTime() {
            return this.longWaitTime;
        }

        public ConditionFactory shortWaitCondition() {
            return Awaitility.await().pollDelay(Duration.ZERO).pollInterval(Durations.ONE_HUNDRED_MILLISECONDS).timeout(this.getShortWaitTime());
        }

        public ConditionFactory longWaitCondition() {
            return Awaitility.await().pollDelay(Duration.ZERO).pollInterval(Durations.ONE_HUNDRED_MILLISECONDS).timeout(this.getLongWaitTime());
        }
    }
}

