/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventBusContract;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.EventListener;
import org.apache.james.events.Registration;
import org.assertj.core.api.Assertions;
import org.awaitility.Durations;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public interface KeyContract
extends EventBusContract {

    public static interface MultipleEventBusKeyContract
    extends EventBusContract.MultipleEventBusContract {
        @Test
        default public void crossEventBusRegistrationShouldBeAllowed() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            this.eventBus2().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.KEY_1).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void unregisteredDistantListenersShouldNotBeNotified() throws Exception {
            EventListener eventListener = EventBusTestFixture.newListener();
            ((Registration)Mono.from((Publisher)this.eventBus().register(eventListener, EventBusTestFixture.KEY_1)).block()).unregister();
            this.eventBus2().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
            ((EventListener)Mockito.verify((Object)eventListener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void allRegisteredListenersShouldBeDispatched() throws Exception {
            EventListener listener1 = EventBusTestFixture.newListener();
            EventListener listener2 = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener1, EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus2().register(listener2, EventBusTestFixture.KEY_1)).block();
            this.eventBus2().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.KEY_1).block();
            ((EventListener)Mockito.verify((Object)listener1, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
            ((EventListener)Mockito.verify((Object)listener2, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void registerShouldNotDispatchPastEventsInDistributedContext() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus2().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void localDispatchedListenersShouldBeDispatchedWithoutDelay() throws Exception {
            EventListener listener1 = EventBusTestFixture.newListener();
            EventListener listener2 = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener1, EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus2().register(listener2, EventBusTestFixture.KEY_1)).block();
            this.eventBus2().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.KEY_1).block();
            ((EventListener)Mockito.verify((Object)listener2, (VerificationMode)Mockito.times((int)1))).event((Event)ArgumentMatchers.any());
            ((EventListener)Mockito.verify((Object)listener1, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }
    }

    public static interface SingleEventBusKeyContract
    extends EventBusContract {
        @Test
        default public void notificationShouldNotExceedRate() {
            int eventCount = 50;
            AtomicInteger nbCalls = new AtomicInteger(0);
            AtomicInteger finishedExecutions = new AtomicInteger(0);
            AtomicBoolean rateExceeded = new AtomicBoolean(false);
            Mono.from((Publisher)this.eventBus().register(event -> {
                if (nbCalls.get() - finishedExecutions.get() > 10) {
                    rateExceeded.set(true);
                }
                nbCalls.incrementAndGet();
                Thread.sleep(Duration.ofMillis(20L).toMillis());
                finishedExecutions.incrementAndGet();
            }, EventBusTestFixture.KEY_1)).block();
            IntStream.range(0, eventCount).forEach(i -> this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.KEY_1).block());
            this.getSpeedProfile().shortWaitCondition().atMost(Durations.TEN_MINUTES).untilAsserted(() -> Assertions.assertThat((int)finishedExecutions.get()).isEqualTo(eventCount));
            Assertions.assertThat((AtomicBoolean)rateExceeded).isFalse();
        }

        @Test
        default public void notificationShouldDeliverASingleEventToAllListenersAtTheSameTime() {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            try {
                ConcurrentLinkedQueue threads = new ConcurrentLinkedQueue();
                Mono.from((Publisher)this.eventBus().register(event -> {
                    threads.add(Thread.currentThread().getName());
                    countDownLatch.await();
                }, EventBusTestFixture.KEY_1)).block();
                Mono.from((Publisher)this.eventBus().register(event -> {
                    threads.add(Thread.currentThread().getName());
                    countDownLatch.await();
                }, EventBusTestFixture.KEY_1)).block();
                Mono.from((Publisher)this.eventBus().register(event -> {
                    threads.add(Thread.currentThread().getName());
                    countDownLatch.await();
                }, EventBusTestFixture.KEY_1)).block();
                this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.KEY_1).subscribeOn(Schedulers.elastic()).subscribe();
                this.getSpeedProfile().shortWaitCondition().atMost(Durations.TEN_SECONDS).untilAsserted(() -> Assertions.assertThat((Collection)threads).hasSize(3));
                Assertions.assertThat(threads).doesNotHaveDuplicates();
            }
            finally {
                countDownLatch.countDown();
            }
        }

        @Test
        default public void registeredListenersShouldNotReceiveNoopEvents() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            EventBusTestFixture.TestEvent noopEvent = new EventBusTestFixture.TestEvent(EventBusTestFixture.EVENT_ID, Username.of((String)"noop"));
            this.eventBus().dispatch((Event)noopEvent, EventBusTestFixture.KEY_1).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void registeredListenersShouldReceiveOnlyHandledEvents() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT_UNSUPPORTED_BY_LISTENER, EventBusTestFixture.KEY_1).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void dispatchShouldNotThrowWhenARegisteredListenerFails() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            ((EventListener)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)listener)).event((Event)ArgumentMatchers.any());
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            Assertions.assertThatCode(() -> this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block()).doesNotThrowAnyException();
        }

        @Test
        default public void dispatchShouldNotNotifyRegisteredListenerWhenEmptyKeySet() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void dispatchShouldNotNotifyListenerRegisteredOnOtherKeys() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_2)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void dispatchShouldNotifyRegisteredListeners() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void dispatchShouldNotifyLocalRegisteredListenerWithoutDelay() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void dispatchShouldNotifyOnlyRegisteredListener() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            EventListener listener2 = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus().register(listener2, EventBusTestFixture.KEY_2)).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
            ((EventListener)Mockito.verify((Object)listener2, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void dispatchShouldNotifyAllListenersRegisteredOnAKey() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            EventListener listener2 = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus().register(listener2, EventBusTestFixture.KEY_1)).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
            ((EventListener)Mockito.verify((Object)listener2, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void registerShouldAllowDuplicatedRegistration() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void unregisterShouldRemoveDoubleRegisteredListener() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            ((Registration)Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block()).unregister();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void registerShouldNotDispatchPastEvents() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void callingAllUnregisterMethodShouldUnregisterTheListener() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Registration registration = (Registration)Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            ((Registration)Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block()).unregister();
            registration.unregister();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void unregisterShouldHaveNotNotifyWhenCalledOnDifferentKeys() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            ((Registration)Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_2)).block()).unregister();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void unregisterShouldBeIdempotentForKeyRegistrations() {
            EventListener listener = EventBusTestFixture.newListener();
            Registration registration = (Registration)Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            registration.unregister();
            Assertions.assertThatCode(() -> ((Registration)registration).unregister()).doesNotThrowAnyException();
        }

        @Test
        default public void dispatchShouldAcceptSeveralKeys() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1, (Object)EventBusTestFixture.KEY_2)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void dispatchShouldCallListenerOnceWhenSeveralKeysMatching() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_2)).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1, (Object)EventBusTestFixture.KEY_2)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void dispatchShouldNotNotifyUnregisteredListener() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            ((Registration)Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block()).unregister();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void dispatchShouldNotifyAsynchronousListener() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Mockito.when((Object)listener.getExecutionMode()).thenReturn((Object)EventListener.ExecutionMode.ASYNCHRONOUS);
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.KEY_1).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()))).event(EventBusTestFixture.EVENT);
        }

        @Test
        default public void dispatchShouldNotBlockAsynchronousListener() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Mockito.when((Object)listener.getExecutionMode()).thenReturn((Object)EventListener.ExecutionMode.ASYNCHRONOUS);
            CountDownLatch latch = new CountDownLatch(1);
            ((EventListener)Mockito.doAnswer(invocation -> {
                latch.await();
                return null;
            }).when((Object)listener)).event(EventBusTestFixture.EVENT);
            org.junit.jupiter.api.Assertions.assertTimeout((Duration)Duration.ofSeconds(2L), () -> {
                this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
                latch.countDown();
            });
        }

        @Test
        default public void failingRegisteredListenersShouldNotAbortRegisteredDelivery() {
            EventBusTestFixture.EventMatcherThrowingListener listener = new EventBusTestFixture.EventMatcherThrowingListener((ImmutableSet<Event>)ImmutableSet.of((Object)EventBusTestFixture.EVENT));
            Mono.from((Publisher)this.eventBus().register((EventListener)listener, EventBusTestFixture.KEY_1)).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.KEY_1).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT_2, EventBusTestFixture.KEY_1).block();
            this.getSpeedProfile().shortWaitCondition().untilAsserted(() -> Assertions.assertThat((int)listener.numberOfEventCalls()).isEqualTo(1));
        }

        @Test
        default public void allRegisteredListenersShouldBeExecutedWhenARegisteredListenerFails() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            EventListener failingListener = (EventListener)Mockito.mock(EventListener.class);
            Mockito.when((Object)failingListener.getExecutionMode()).thenReturn((Object)EventListener.ExecutionMode.SYNCHRONOUS);
            ((EventListener)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)failingListener)).event((Event)ArgumentMatchers.any());
            Mono.from((Publisher)this.eventBus().register(failingListener, EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus().register(listener, EventBusTestFixture.KEY_1)).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }
    }
}

