/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventBusContract;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.events.GroupAlreadyRegistered;
import org.apache.james.events.GroupRegistrationNotFound;
import org.apache.james.events.Registration;
import org.apache.james.mailbox.events.GenericGroup;
import org.assertj.core.api.Assertions;
import org.awaitility.Durations;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import reactor.core.scheduler.Schedulers;

public interface GroupContract {

    public static interface MultipleEventBusGroupContract
    extends EventBusContract.MultipleEventBusContract {
        @Test
        default public void groupsDefinedOnlyOnSomeNodesShouldBeNotifiedWhenDispatch() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus2().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void groupsDefinedOnlyOnSomeNodesShouldNotBeNotifiedWhenRedeliver() {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            Assertions.assertThatThrownBy(() -> this.eventBus2().reDeliver((Group)EventBusTestFixture.GROUP_A, EventBusTestFixture.EVENT).block()).isInstanceOf(GroupRegistrationNotFound.class);
        }

        @Test
        default public void groupListenersShouldBeExecutedOnceWhenRedeliverInADistributedEnvironment() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus2().register(listener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus2().reDeliver((Group)EventBusTestFixture.GROUP_A, EventBusTestFixture.EVENT).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void groupListenersShouldBeExecutedOnceInAControlledEnvironment() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus2().register(listener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus2().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void unregisterShouldStopNotificationForDistantGroups() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A).unregister();
            this.eventBus2().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void registerShouldNotDispatchPastEventsForGroupsInADistributedContext() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            this.eventBus2().register(listener, (Group)EventBusTestFixture.GROUP_A);
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }
    }

    public static interface SingleEventBusGroupContract
    extends EventBusContract {
        @Test
        default public void groupDeliveryShouldNotExceedRate() {
            int eventCount = 50;
            final AtomicInteger nbCalls = new AtomicInteger(0);
            final AtomicInteger inFlight = new AtomicInteger(0);
            final AtomicBoolean rateExceeded = new AtomicBoolean(false);
            this.eventBus().register((EventListener)new EventListener.GroupEventListener(){

                public Group getDefaultGroup() {
                    return new GenericGroup("group");
                }

                public boolean isHandling(Event event) {
                    return true;
                }

                public void event(Event event) throws Exception {
                    if (inFlight.incrementAndGet() > 10) {
                        rateExceeded.set(true);
                    }
                    nbCalls.incrementAndGet();
                    Thread.sleep(Duration.ofMillis(20L).toMillis());
                    inFlight.decrementAndGet();
                }
            }, (Group)EventBusTestFixture.GROUP_A);
            IntStream.range(0, eventCount).forEach(i -> this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block());
            this.getSpeedProfile().shortWaitCondition().atMost(Durations.TEN_MINUTES).untilAsserted(() -> Assertions.assertThat((int)nbCalls.get()).isEqualTo(eventCount));
            Assertions.assertThat((AtomicBoolean)rateExceeded).isFalse();
        }

        @Test
        default public void groupNotificationShouldDeliverASingleEventToAllListenersAtTheSameTime() {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            try {
                final ConcurrentLinkedQueue threads = new ConcurrentLinkedQueue();
                this.eventBus().register((EventListener)new EventListener.GroupEventListener(){

                    public Group getDefaultGroup() {
                        return new GenericGroup("groupA");
                    }

                    public void event(Event event) throws Exception {
                        threads.add(Thread.currentThread().getName());
                        countDownLatch.await();
                    }
                }, (Group)EventBusTestFixture.GROUP_A);
                this.eventBus().register((EventListener)new EventListener.GroupEventListener(){

                    public Group getDefaultGroup() {
                        return new GenericGroup("groupB");
                    }

                    public void event(Event event) throws Exception {
                        threads.add(Thread.currentThread().getName());
                        countDownLatch.await();
                    }
                }, (Group)EventBusTestFixture.GROUP_B);
                this.eventBus().register((EventListener)new EventListener.GroupEventListener(){

                    public Group getDefaultGroup() {
                        return new GenericGroup("groupC");
                    }

                    public void event(Event event) throws Exception {
                        threads.add(Thread.currentThread().getName());
                        countDownLatch.await();
                    }
                }, (Group)EventBusTestFixture.GROUP_C);
                this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).subscribeOn(Schedulers.elastic()).subscribe();
                this.getSpeedProfile().shortWaitCondition().atMost(Durations.TEN_SECONDS).untilAsserted(() -> Assertions.assertThat((Collection)threads).hasSize(3));
                Assertions.assertThat(threads).doesNotHaveDuplicates();
            }
            finally {
                countDownLatch.countDown();
            }
        }

        @Test
        default public void listenersShouldBeAbleToDispatch() {
            AtomicBoolean successfulRetry = new AtomicBoolean(false);
            EventListener listener = event -> {
                if (event.getEventId().equals((Object)EventBusTestFixture.EVENT_ID)) {
                    this.eventBus().dispatch(EventBusTestFixture.EVENT_2, EventBusTestFixture.NO_KEYS).subscribeOn(Schedulers.elastic()).block();
                    successfulRetry.set(true);
                }
            };
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            this.getSpeedProfile().shortWaitCondition().until(successfulRetry::get);
        }

        @Test
        default public void registerShouldNotDispatchPastEventsForGroups() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            Thread.sleep(100L);
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void listenerGroupShouldReceiveEvents() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void groupListenersShouldNotReceiveNoopEvents() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            EventBusTestFixture.TestEvent noopEvent = new EventBusTestFixture.TestEvent(EventBusTestFixture.EVENT_ID, Username.of((String)"noop"));
            this.eventBus().dispatch((Event)noopEvent, EventBusTestFixture.NO_KEYS).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void groupListenersShouldReceiveOnlyHandledEvents() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus().dispatch(EventBusTestFixture.EVENT_UNSUPPORTED_BY_LISTENER, EventBusTestFixture.NO_KEYS).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void dispatchShouldNotThrowWhenAGroupListenerFails() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            ((EventListener)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)listener)).event((Event)ArgumentMatchers.any());
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            Assertions.assertThatCode(() -> this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block()).doesNotThrowAnyException();
        }

        @Test
        default public void eachListenerGroupShouldReceiveEvents() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            EventListener listener2 = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus().register(listener2, (Group)EventBusTestFixture.GROUP_B);
            this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
            ((EventListener)Mockito.verify((Object)listener2, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void unregisteredGroupListenerShouldNotReceiveEvents() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            Registration registration = this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            registration.unregister();
            this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void registerShouldThrowWhenAGroupIsAlreadyUsed() {
            EventListener listener = EventBusTestFixture.newListener();
            EventListener listener2 = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            Assertions.assertThatThrownBy(() -> this.eventBus().register(listener2, (Group)EventBusTestFixture.GROUP_A)).isInstanceOf(GroupAlreadyRegistered.class);
        }

        @Test
        default public void registerShouldNotThrowOnAnUnregisteredGroup() {
            EventListener listener = EventBusTestFixture.newListener();
            EventListener listener2 = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A).unregister();
            Assertions.assertThatCode(() -> this.eventBus().register(listener2, (Group)EventBusTestFixture.GROUP_A)).doesNotThrowAnyException();
        }

        @Test
        default public void unregisterShouldBeIdempotentForGroups() {
            EventListener listener = EventBusTestFixture.newListener();
            Registration registration = this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            registration.unregister();
            Assertions.assertThatCode(() -> ((Registration)registration).unregister()).doesNotThrowAnyException();
        }

        @Test
        default public void registerShouldAcceptAlreadyUnregisteredGroups() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A).unregister();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void dispatchShouldCallSynchronousListener() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void failingGroupListenersShouldNotAbortGroupDelivery() {
            EventBusTestFixture.EventMatcherThrowingListener listener = new EventBusTestFixture.EventMatcherThrowingListener((ImmutableSet<Event>)ImmutableSet.of((Object)EventBusTestFixture.EVENT));
            this.eventBus().register((EventListener)listener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            this.eventBus().dispatch(EventBusTestFixture.EVENT_2, EventBusTestFixture.NO_KEYS).block();
            this.getSpeedProfile().shortWaitCondition().untilAsserted(() -> Assertions.assertThat((int)listener.numberOfEventCalls()).isEqualTo(1));
        }

        @Test
        default public void allGroupListenersShouldBeExecutedWhenAGroupListenerFails() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            EventListener failingListener = (EventListener)Mockito.mock(EventListener.class);
            Mockito.when((Object)failingListener.getExecutionMode()).thenReturn((Object)EventListener.ExecutionMode.SYNCHRONOUS);
            ((EventListener)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)failingListener)).event((Event)ArgumentMatchers.any());
            this.eventBus().register(failingListener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_B);
            this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void allGroupListenersShouldBeExecutedWhenGenericGroups() throws Exception {
            EventListener listener1 = EventBusTestFixture.newListener();
            EventListener listener2 = EventBusTestFixture.newListener();
            this.eventBus().register(listener1, (Group)new GenericGroup("a"));
            this.eventBus().register(listener2, (Group)new GenericGroup("b"));
            this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
            ((EventListener)Mockito.verify((Object)listener1, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
            ((EventListener)Mockito.verify((Object)listener2, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void groupListenerShouldReceiveEventWhenRedeliver() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus().reDeliver((Group)EventBusTestFixture.GROUP_A, EventBusTestFixture.EVENT).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void redeliverShouldNotThrowWhenAGroupListenerFails() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            ((EventListener)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)listener)).event((Event)ArgumentMatchers.any());
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            Assertions.assertThatCode(() -> this.eventBus().reDeliver((Group)EventBusTestFixture.GROUP_A, EventBusTestFixture.EVENT).block()).doesNotThrowAnyException();
        }

        @Test
        default public void redeliverShouldThrowWhenGroupNotRegistered() {
            Assertions.assertThatThrownBy(() -> this.eventBus().reDeliver((Group)EventBusTestFixture.GROUP_A, EventBusTestFixture.EVENT).block()).isInstanceOf(GroupRegistrationNotFound.class);
        }

        @Test
        default public void redeliverShouldThrowAfterGroupIsUnregistered() {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A).unregister();
            Assertions.assertThatThrownBy(() -> this.eventBus().reDeliver((Group)EventBusTestFixture.GROUP_A, EventBusTestFixture.EVENT).block()).isInstanceOf(GroupRegistrationNotFound.class);
        }

        @Test
        default public void redeliverShouldOnlySendEventToDefinedGroup() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            EventListener listener2 = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            this.eventBus().register(listener2, (Group)EventBusTestFixture.GROUP_B);
            this.eventBus().reDeliver((Group)EventBusTestFixture.GROUP_A, EventBusTestFixture.EVENT).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)EventBusTestFixture.ONE_SECOND.toMillis()).times(1))).event((Event)ArgumentMatchers.any());
            ((EventListener)Mockito.verify((Object)listener2, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }

        @Test
        default public void groupListenersShouldNotReceiveNoopRedeliveredEvents() throws Exception {
            EventListener listener = EventBusTestFixture.newListener();
            this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
            EventBusTestFixture.TestEvent noopEvent = new EventBusTestFixture.TestEvent(EventBusTestFixture.EVENT_ID, Username.of((String)"noop"));
            this.eventBus().reDeliver((Group)EventBusTestFixture.GROUP_A, (Event)noopEvent).block();
            ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.after((long)EventBusTestFixture.FIVE_HUNDRED_MS.toMillis()).never())).event((Event)ArgumentMatchers.any());
        }
    }
}

