/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.Group;
import org.apache.james.util.concurrency.ConcurrentTestRunner;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

interface EventDeadLettersContract {
    public static final List<Group> CONCURRENT_GROUPS = ImmutableList.of((Object)((Object)new Group0()), (Object)((Object)new Group1()), (Object)((Object)new Group2()), (Object)((Object)new Group3()), (Object)((Object)new Group4()), (Object)((Object)new Group5()), (Object)((Object)new Group6()), (Object)((Object)new Group7()), (Object)((Object)new Group8()), (Object)((Object)new Group9()));
    public static final Duration RUN_SUCCESSFULLY_IN = Duration.ofSeconds(5L);
    public static final int THREAD_COUNT = 10;
    public static final int OPERATION_COUNT = 50;
    public static final Username USERNAME = Username.of((String)"user");
    public static final Event.EventId EVENT_ID_1 = Event.EventId.of((String)"6e0dd59d-660e-4d9b-b22f-0354479f47b4");
    public static final Event.EventId EVENT_ID_2 = Event.EventId.of((String)"6e0dd59d-660e-4d9b-b22f-0354479f47b5");
    public static final Event.EventId EVENT_ID_3 = Event.EventId.of((String)"6e0dd59d-660e-4d9b-b22f-0354479f47b6");
    public static final Event EVENT_1 = new EventBusTestFixture.TestEvent(EVENT_ID_1, USERNAME);
    public static final Event EVENT_2 = new EventBusTestFixture.TestEvent(EVENT_ID_2, USERNAME);
    public static final Event EVENT_3 = new EventBusTestFixture.TestEvent(EVENT_ID_3, USERNAME);
    public static final EventDeadLetters.InsertionId INSERTION_ID_1 = EventDeadLetters.InsertionId.of((String)"6e0dd59d-660e-4d9b-b22f-0354479f47b7");
    public static final EventDeadLetters.InsertionId INSERTION_ID_2 = EventDeadLetters.InsertionId.of((String)"6e0dd59d-660e-4d9b-b22f-0354479f47b8");
    public static final EventDeadLetters.InsertionId INSERTION_ID_3 = EventDeadLetters.InsertionId.of((String)"6e0dd59d-660e-4d9b-b22f-0354479f47b9");
    public static final Group GROUP_A = new EventBusTestFixture.GroupA();
    public static final Group GROUP_B = new EventBusTestFixture.GroupB();
    public static final Group NULL_GROUP = null;
    public static final Event NULL_EVENT = null;
    public static final EventDeadLetters.InsertionId NULL_INSERTION_ID = null;

    public static ImmutableMap<Integer, Group> concurrentGroups() {
        return (ImmutableMap)IntStream.range(0, CONCURRENT_GROUPS.size()).boxed().collect(ImmutableMap.toImmutableMap(Function.identity(), CONCURRENT_GROUPS::get));
    }

    public static Event event(Event.EventId eventId) {
        return new EventBusTestFixture.TestEvent(eventId, USERNAME);
    }

    public EventDeadLetters eventDeadLetters();

    default public Stream<EventDeadLetters.InsertionId> allInsertionIds() {
        EventDeadLetters eventDeadLetters = this.eventDeadLetters();
        return eventDeadLetters.groupsWithFailedEvents().flatMap(arg_0 -> ((EventDeadLetters)eventDeadLetters).failedIds(arg_0)).toStream();
    }

    public static interface AllContracts
    extends StoreContract,
    RemoveContract,
    FailedEventContract,
    FailedEventsContract,
    GroupsWithFailedEventsContract,
    ContainEventsContract {
    }

    public static interface ContainEventsContract
    extends EventDeadLettersContract {
        @Test
        default public void containEventsShouldReturnFalseOnNothingStored() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            Assertions.assertThat((Boolean)((Boolean)eventDeadLetters.containEvents().block())).isFalse();
        }

        @Test
        default public void containEventsShouldReturnTrueOnStoredEvents() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            eventDeadLetters.store(GROUP_A, EVENT_1).block();
            Assertions.assertThat((Boolean)((Boolean)eventDeadLetters.containEvents().block())).isTrue();
        }

        @Test
        default public void containEventsShouldReturnFalseWhenRemoveAllStoredEvents() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            EventDeadLetters.InsertionId insertionId1 = (EventDeadLetters.InsertionId)this.eventDeadLetters().store(GROUP_A, EVENT_1).block();
            EventDeadLetters.InsertionId insertionId2 = (EventDeadLetters.InsertionId)this.eventDeadLetters().store(GROUP_A, EVENT_2).block();
            Assertions.assertThat((Boolean)((Boolean)eventDeadLetters.containEvents().block())).isTrue();
            eventDeadLetters.remove(GROUP_A, insertionId1).block();
            eventDeadLetters.remove(GROUP_A, insertionId2).block();
            Assertions.assertThat((Boolean)((Boolean)eventDeadLetters.containEvents().block())).isFalse();
        }

        @Test
        default public void containEventsShouldReturnTrueWhenRemoveSomeStoredEvents() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            EventDeadLetters.InsertionId insertionId1 = (EventDeadLetters.InsertionId)this.eventDeadLetters().store(GROUP_A, EVENT_1).block();
            this.eventDeadLetters().store(GROUP_B, EVENT_2).block();
            Assertions.assertThat((Boolean)((Boolean)eventDeadLetters.containEvents().block())).isTrue();
            eventDeadLetters.remove(GROUP_A, insertionId1).block();
            Assertions.assertThat((Boolean)((Boolean)eventDeadLetters.containEvents().block())).isTrue();
        }
    }

    public static interface GroupsWithFailedEventsContract
    extends EventDeadLettersContract {
        @Test
        default public void groupsWithFailedEventsShouldReturnAllStoredGroups() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            eventDeadLetters.store(GROUP_A, EVENT_1).block();
            eventDeadLetters.store(GROUP_B, EVENT_1).block();
            Assertions.assertThat((List)((List)eventDeadLetters.groupsWithFailedEvents().collectList().block())).containsOnly((Object[])new Group[]{GROUP_A, GROUP_B});
        }

        @Test
        default public void groupsWithFailedEventsShouldReturnEmptyWhenNoStored() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            Assertions.assertThat((Stream)eventDeadLetters.groupsWithFailedEvents().toStream()).isEmpty();
        }
    }

    public static interface FailedEventsContract
    extends EventDeadLettersContract {
        @Test
        default public void failedEventsShouldThrowWhenGroupIsNull() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            Assertions.assertThatThrownBy(() -> eventDeadLetters.failedIds(NULL_GROUP)).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        default public void failedEventsByGroupShouldReturnEmptyWhenNonMatch() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            eventDeadLetters.store(GROUP_A, EVENT_1).block();
            eventDeadLetters.store(GROUP_A, EVENT_2).block();
            eventDeadLetters.store(GROUP_A, EVENT_3).block();
            Assertions.assertThat((Stream)eventDeadLetters.failedIds(GROUP_B).toStream()).isEmpty();
        }

        @Test
        default public void failedEventsByGroupShouldReturnAllEventsCorrespondingToGivenGroup() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            EventDeadLetters.InsertionId insertionId = (EventDeadLetters.InsertionId)eventDeadLetters.store(GROUP_A, EVENT_1).block();
            eventDeadLetters.store(GROUP_B, EVENT_2).block();
            eventDeadLetters.store(GROUP_B, EVENT_3).block();
            Assertions.assertThat((Stream)eventDeadLetters.failedIds(GROUP_A).toStream()).containsOnly((Object[])new EventDeadLetters.InsertionId[]{insertionId});
        }

        @Test
        default public void failedEventsByGroupShouldNotRemoveEvents() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            EventDeadLetters.InsertionId insertionId1 = (EventDeadLetters.InsertionId)eventDeadLetters.store(GROUP_A, EVENT_1).block();
            EventDeadLetters.InsertionId insertionId2 = (EventDeadLetters.InsertionId)eventDeadLetters.store(GROUP_A, EVENT_2).block();
            EventDeadLetters.InsertionId insertionId3 = (EventDeadLetters.InsertionId)eventDeadLetters.store(GROUP_B, EVENT_3).block();
            eventDeadLetters.failedIds(GROUP_A).toStream();
            Assertions.assertThat(this.allInsertionIds()).containsOnly((Object[])new EventDeadLetters.InsertionId[]{insertionId1, insertionId2, insertionId3});
        }
    }

    public static interface FailedEventContract
    extends EventDeadLettersContract {
        @Test
        default public void failedEventShouldThrowWhenGroupIsNull() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            Assertions.assertThatThrownBy(() -> eventDeadLetters.failedEvent(NULL_GROUP, INSERTION_ID_1)).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        default public void failedEventShouldThrowWhenInsertionIdIsNull() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            Assertions.assertThatThrownBy(() -> eventDeadLetters.failedEvent(GROUP_A, NULL_INSERTION_ID)).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        default public void failedEventShouldThrowWhenBothGroupAndInsertionIdAreNull() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            Assertions.assertThatThrownBy(() -> eventDeadLetters.failedEvent(NULL_GROUP, NULL_INSERTION_ID)).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        default public void failedEventShouldReturnEmptyWhenNotFound() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            eventDeadLetters.store(GROUP_A, EVENT_1).block();
            eventDeadLetters.store(GROUP_A, EVENT_2).block();
            Assertions.assertThat((Object)((Event)eventDeadLetters.failedEvent(GROUP_A, INSERTION_ID_3).block())).isNull();
        }

        @Test
        default public void failedEventShouldReturnEventWhenContains() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            EventDeadLetters.InsertionId insertionId = (EventDeadLetters.InsertionId)eventDeadLetters.store(GROUP_A, EVENT_1).block();
            eventDeadLetters.store(GROUP_A, EVENT_2).block();
            Assertions.assertThat((Object)((Event)eventDeadLetters.failedEvent(GROUP_A, insertionId).block())).isEqualTo((Object)EVENT_1);
        }

        @Test
        default public void failedEventShouldNotRemoveEvent() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            EventDeadLetters.InsertionId insertionId1 = (EventDeadLetters.InsertionId)eventDeadLetters.store(GROUP_A, EVENT_1).block();
            EventDeadLetters.InsertionId insertionId2 = (EventDeadLetters.InsertionId)eventDeadLetters.store(GROUP_A, EVENT_2).block();
            EventDeadLetters.InsertionId insertionId3 = (EventDeadLetters.InsertionId)eventDeadLetters.store(GROUP_A, EVENT_3).block();
            eventDeadLetters.failedEvent(GROUP_A, insertionId1).block();
            Assertions.assertThat(this.allInsertionIds()).containsOnly((Object[])new EventDeadLetters.InsertionId[]{insertionId1, insertionId2, insertionId3});
        }

        @Test
        default public void failedEventShouldNotThrowWhenNoGroupMatched() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            EventDeadLetters.InsertionId insertionId = (EventDeadLetters.InsertionId)eventDeadLetters.store(GROUP_A, EVENT_1).block();
            Assertions.assertThatCode(() -> eventDeadLetters.failedEvent(GROUP_B, insertionId).block()).doesNotThrowAnyException();
        }
    }

    public static interface RemoveContract
    extends EventDeadLettersContract {
        @Test
        default public void removeShouldThrowWhenGroupIsNull() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            Assertions.assertThatThrownBy(() -> eventDeadLetters.remove(NULL_GROUP, INSERTION_ID_1)).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        default public void removeShouldThrowWhenInsertionIdIsNull() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            Assertions.assertThatThrownBy(() -> eventDeadLetters.remove(GROUP_A, NULL_INSERTION_ID)).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        default public void removeShouldThrowWhenBothGroupAndInsertionIdAreNull() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            Assertions.assertThatThrownBy(() -> eventDeadLetters.remove(NULL_GROUP, NULL_INSERTION_ID)).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        default public void removeShouldRemoveMatched() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            eventDeadLetters.store(GROUP_A, EVENT_1).block();
            eventDeadLetters.store(GROUP_A, EVENT_2).block();
            eventDeadLetters.remove(GROUP_A, INSERTION_ID_1).block();
            Assertions.assertThat((Object)((Event)eventDeadLetters.failedEvent(GROUP_A, INSERTION_ID_1).block())).isNull();
        }

        @Test
        default public void removeShouldKeepNonMatched() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            EventDeadLetters.InsertionId insertionId1 = (EventDeadLetters.InsertionId)eventDeadLetters.store(GROUP_A, EVENT_1).block();
            EventDeadLetters.InsertionId insertionId2 = (EventDeadLetters.InsertionId)eventDeadLetters.store(GROUP_A, EVENT_2).block();
            EventDeadLetters.InsertionId insertionId3 = (EventDeadLetters.InsertionId)eventDeadLetters.store(GROUP_A, EVENT_3).block();
            eventDeadLetters.remove(GROUP_A, insertionId1).block();
            Assertions.assertThat((Stream)eventDeadLetters.failedIds(GROUP_A).toStream()).containsOnly((Object[])new EventDeadLetters.InsertionId[]{insertionId2, insertionId3});
        }

        @Test
        default public void removeShouldNotThrowWhenNoInsertionIdMatched() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            eventDeadLetters.store(GROUP_A, EVENT_1).block();
            Assertions.assertThatCode(() -> eventDeadLetters.remove(GROUP_A, INSERTION_ID_2).block()).doesNotThrowAnyException();
        }

        @Test
        default public void removeShouldNotThrowWhenNoGroupMatched() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            eventDeadLetters.store(GROUP_A, EVENT_1).block();
            Assertions.assertThatCode(() -> eventDeadLetters.remove(GROUP_B, INSERTION_ID_1).block()).doesNotThrowAnyException();
        }

        @Test
        default public void removeShouldKeepConsistencyWhenConcurrentRemove() throws Exception {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            ImmutableMap<Integer, Group> groups = EventDeadLettersContract.concurrentGroups();
            ConcurrentHashMap storedInsertionIds = new ConcurrentHashMap();
            ConcurrentTestRunner.builder().operation((threadNumber, step) -> {
                int operationIndex = threadNumber * 50 + step;
                Event.EventId eventId = Event.EventId.random();
                EventDeadLetters.InsertionId insertionId = (EventDeadLetters.InsertionId)eventDeadLetters.store((Group)groups.get((Object)threadNumber), EventDeadLettersContract.event(eventId)).block();
                storedInsertionIds.put(operationIndex, insertionId);
            }).threadCount(10).operationCount(50).runSuccessfullyWithin(RUN_SUCCESSFULLY_IN);
            ConcurrentTestRunner.builder().operation((threadNumber, step) -> {
                int operationIndex = threadNumber * 50 + step;
                eventDeadLetters.remove((Group)groups.get((Object)threadNumber), (EventDeadLetters.InsertionId)storedInsertionIds.get(operationIndex)).block();
            }).threadCount(10).operationCount(50).runSuccessfullyWithin(RUN_SUCCESSFULLY_IN);
            Assertions.assertThat(this.allInsertionIds()).isEmpty();
        }
    }

    public static interface StoreContract
    extends EventDeadLettersContract {
        @Test
        default public void storeShouldThrowWhenNullGroup() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            Assertions.assertThatThrownBy(() -> eventDeadLetters.store(NULL_GROUP, EVENT_1)).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        default public void storeShouldThrowWhenNullEvent() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            Assertions.assertThatThrownBy(() -> eventDeadLetters.store(GROUP_A, NULL_EVENT)).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        default public void storeShouldThrowWhenBothGroupAndEventAndInsertionIdAreNull() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            Assertions.assertThatThrownBy(() -> eventDeadLetters.store(NULL_GROUP, NULL_EVENT)).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        default public void storeShouldStoreGroupWithCorrespondingEvent() {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            EventDeadLetters.InsertionId insertionId = (EventDeadLetters.InsertionId)eventDeadLetters.store(GROUP_A, EVENT_1).block();
            Assertions.assertThat((Object)((Event)eventDeadLetters.failedEvent(GROUP_A, insertionId).block())).isEqualTo((Object)EVENT_1);
        }

        @Test
        default public void storeShouldKeepConsistencyWhenConcurrentStore() throws Exception {
            EventDeadLetters eventDeadLetters = this.eventDeadLetters();
            ImmutableMap<Integer, Group> groups = EventDeadLettersContract.concurrentGroups();
            SetMultimap storedInsertionIds = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
            ConcurrentTestRunner.builder().operation((arg_0, arg_1) -> StoreContract.lambda$storeShouldKeepConsistencyWhenConcurrentStore$3(eventDeadLetters, groups, (Multimap)storedInsertionIds, arg_0, arg_1)).threadCount(10).operationCount(50).runSuccessfullyWithin(RUN_SUCCESSFULLY_IN);
            groups.forEach((arg_0, arg_1) -> StoreContract.lambda$storeShouldKeepConsistencyWhenConcurrentStore$4(groups, eventDeadLetters, (Multimap)storedInsertionIds, arg_0, arg_1));
        }

        private static /* synthetic */ void lambda$storeShouldKeepConsistencyWhenConcurrentStore$4(ImmutableMap groups, EventDeadLetters eventDeadLetters, Multimap storedInsertionIds, Integer groupId, Group group) {
            Group storedGroup = (Group)groups.get((Object)groupId);
            Assertions.assertThat((List)((List)eventDeadLetters.failedIds(storedGroup).collectList().block())).hasSameElementsAs((Iterable)storedInsertionIds.get((Object)groupId));
        }

        private static /* synthetic */ void lambda$storeShouldKeepConsistencyWhenConcurrentStore$3(EventDeadLetters eventDeadLetters, ImmutableMap groups, Multimap storedInsertionIds, int threadNumber, int step) throws Exception {
            Event.EventId eventId = Event.EventId.random();
            EventDeadLetters.InsertionId insertionId = (EventDeadLetters.InsertionId)eventDeadLetters.store((Group)groups.get((Object)threadNumber), EventDeadLettersContract.event(eventId)).block();
            storedInsertionIds.put((Object)threadNumber, (Object)insertionId);
        }
    }

    public static class Group9
    extends Group {
    }

    public static class Group8
    extends Group {
    }

    public static class Group7
    extends Group {
    }

    public static class Group6
    extends Group {
    }

    public static class Group5
    extends Group {
    }

    public static class Group4
    extends Group {
    }

    public static class Group3
    extends Group {
    }

    public static class Group2
    extends Group {
    }

    public static class Group1
    extends Group {
    }

    public static class Group0
    extends Group {
    }
}

