/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.Group;
import org.apache.james.events.RegistrationKey;
import org.apache.james.events.RetryBackoffConfiguration;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public interface EventBusTestFixture {
    public static final Username USERNAME = Username.of((String)"user");
    public static final Event.EventId EVENT_ID = Event.EventId.of((String)"6e0dd59d-660e-4d9b-b22f-0354479f47b4");
    public static final Event.EventId EVENT_ID_2 = Event.EventId.of((String)"5a7a9f3f-5f03-44be-b457-a51e93760645");
    public static final Event EVENT = new TestEvent(EVENT_ID, USERNAME);
    public static final Event EVENT_2 = new TestEvent(EVENT_ID_2, USERNAME);
    public static final Event EVENT_UNSUPPORTED_BY_LISTENER = new UnsupportedEvent(EVENT_ID_2, USERNAME);
    public static final Duration ONE_SECOND = Duration.ofSeconds(1L);
    public static final Duration FIVE_HUNDRED_MS = Duration.ofMillis(500L);
    public static final ImmutableSet<RegistrationKey> NO_KEYS = ImmutableSet.of();
    public static final RegistrationKey KEY_1 = new TestRegistrationKey("a");
    public static final RegistrationKey KEY_2 = new TestRegistrationKey("b");
    public static final RegistrationKey KEY_3 = new TestRegistrationKey("c");
    public static final GroupA GROUP_A = new GroupA();
    public static final GroupB GROUP_B = new GroupB();
    public static final GroupC GROUP_C = new GroupC();
    public static final List<Group> ALL_GROUPS = ImmutableList.of((Object)((Object)GROUP_A), (Object)((Object)GROUP_B), (Object)((Object)GROUP_C));
    public static final Duration DEFAULT_FIRST_BACKOFF = Duration.ofMillis(5L);
    public static final RetryBackoffConfiguration RETRY_BACKOFF_CONFIGURATION = RetryBackoffConfiguration.builder().maxRetries(3).firstBackoff(DEFAULT_FIRST_BACKOFF).jitterFactor(0.5).build();

    public static EventListener newListener() {
        EventListener listener = (EventListener)Mockito.mock(EventListener.class);
        Mockito.when((Object)listener.getExecutionMode()).thenReturn((Object)EventListener.ExecutionMode.SYNCHRONOUS);
        Mockito.when((Object)listener.isHandling((Event)ArgumentMatchers.any(TestEvent.class))).thenReturn((Object)true);
        return listener;
    }

    public static EventListener newAsyncListener() {
        EventListener listener = (EventListener)Mockito.mock(EventListener.class);
        Mockito.when((Object)listener.getExecutionMode()).thenReturn((Object)EventListener.ExecutionMode.ASYNCHRONOUS);
        Mockito.when((Object)listener.isHandling((Event)ArgumentMatchers.any(TestEvent.class))).thenReturn((Object)true);
        return listener;
    }

    public static class TestRegistrationKeyFactory
    implements RegistrationKey.Factory {
        public Class<? extends RegistrationKey> forClass() {
            return TestRegistrationKey.class;
        }

        public RegistrationKey fromString(String asString) {
            return new TestRegistrationKey(asString);
        }
    }

    public static class TestRegistrationKey
    implements RegistrationKey {
        private final String value;

        public TestRegistrationKey(String value) {
            this.value = value;
        }

        public String asString() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o instanceof TestRegistrationKey) {
                TestRegistrationKey that = (TestRegistrationKey)o;
                return Objects.equals(this.value, that.value);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static class TestEventSerializer
    implements EventSerializer {
        public String toJson(Event event) {
            Preconditions.checkArgument((event instanceof TestEvent || event instanceof UnsupportedEvent ? 1 : 0) != 0);
            return event.getClass().getCanonicalName() + "&" + event.getEventId().getId().toString() + "&" + event.getUsername().asString();
        }

        public Event asEvent(String serialized) {
            Preconditions.checkArgument((boolean)serialized.contains("&"));
            List parts = Splitter.on((String)"&").splitToList((CharSequence)serialized);
            Preconditions.checkArgument((boolean)((String)parts.get(0)).equals(TestEvent.class.getCanonicalName()));
            Event.EventId eventId = Event.EventId.of((UUID)UUID.fromString((String)parts.get(1)));
            Username username = Username.of((String)Joiner.on((String)"&").join((Iterable)parts.stream().skip(2L).collect(ImmutableList.toImmutableList())));
            return new TestEvent(eventId, username);
        }
    }

    public static class UnsupportedEvent
    implements Event {
        private final Event.EventId eventId;
        private final Username username;

        public UnsupportedEvent(Event.EventId eventId, Username username) {
            this.eventId = eventId;
            this.username = username;
        }

        public Username getUsername() {
            return this.username;
        }

        public boolean isNoop() {
            return false;
        }

        public Event.EventId getEventId() {
            return this.eventId;
        }

        public boolean equals(Object o) {
            if (o instanceof UnsupportedEvent) {
                UnsupportedEvent that = (UnsupportedEvent)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.username, that.username);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.eventId, this.username);
        }
    }

    public static class TestEvent
    implements Event {
        private final Event.EventId eventId;
        private final Username username;

        public TestEvent(Event.EventId eventId, Username username) {
            this.eventId = eventId;
            this.username = username;
        }

        public Username getUsername() {
            return this.username;
        }

        public boolean isNoop() {
            return this.username.asString().equals("noop");
        }

        public Event.EventId getEventId() {
            return this.eventId;
        }

        public boolean equals(Object o) {
            if (o instanceof TestEvent) {
                TestEvent that = (TestEvent)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.username, that.username);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.eventId, this.username);
        }
    }

    public static class GroupC
    extends Group {
    }

    public static class GroupB
    extends Group {
    }

    public static class GroupA
    extends Group {
    }

    public static class EventMatcherThrowingListener
    extends EventListenerCountingSuccessfulExecution {
        private final ImmutableSet<Event> eventsCauseThrowing;

        EventMatcherThrowingListener(ImmutableSet<Event> eventsCauseThrowing) {
            this.eventsCauseThrowing = eventsCauseThrowing;
        }

        @Override
        public boolean isHandling(Event event) {
            return true;
        }

        @Override
        public void event(Event event) {
            if (this.eventsCauseThrowing.contains((Object)event)) {
                throw new RuntimeException("event triggers throwing");
            }
            super.event(event);
        }
    }

    public static class EventListenerCountingSuccessfulExecution
    implements EventListener {
        private final AtomicInteger calls = new AtomicInteger(0);

        public boolean isHandling(Event event) {
            return true;
        }

        public void event(Event event) {
            this.calls.incrementAndGet();
        }

        public int numberOfEventCalls() {
            return this.calls.get();
        }
    }
}

