/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.Set;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventBusContract;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.EventDeadLettersContract;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.events.RegistrationKey;
import org.apache.james.util.concurrency.ConcurrentTestRunner;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface EventBusConcurrentTestContract {
    public static final Duration FIVE_SECONDS = Duration.ofSeconds(5L);
    public static final ConditionFactory AWAIT_CONDITION = Awaitility.await().timeout(Duration.ofSeconds(5L));
    public static final int THREAD_COUNT = 10;
    public static final int OPERATION_COUNT = 30;
    public static final int TOTAL_DISPATCH_OPERATIONS = 300;
    public static final Set<RegistrationKey> ALL_KEYS = ImmutableSet.of((Object)EventBusTestFixture.KEY_1, (Object)EventBusTestFixture.KEY_2, (Object)EventBusTestFixture.KEY_3);

    public static EventBusTestFixture.EventListenerCountingSuccessfulExecution newCountingListener() {
        return new EventBusTestFixture.EventListenerCountingSuccessfulExecution();
    }

    public static int totalEventsReceived(ImmutableList<EventBusTestFixture.EventListenerCountingSuccessfulExecution> allListeners) {
        return allListeners.stream().mapToInt(EventBusTestFixture.EventListenerCountingSuccessfulExecution::numberOfEventCalls).sum();
    }

    public static interface MultiEventBusConcurrentContract
    extends EventBusContract.MultipleEventBusContract {
        public EventBus eventBus3();

        @Test
        default public void concurrentDispatchGroupShouldDeliverAllEventsToListenersWithMultipleEventBus() throws Exception {
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener1 = EventBusConcurrentTestContract.newCountingListener();
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener2 = EventBusConcurrentTestContract.newCountingListener();
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener3 = EventBusConcurrentTestContract.newCountingListener();
            this.eventBus().register((EventListener)countingListener1, (Group)new EventBusTestFixture.GroupA());
            this.eventBus().register((EventListener)countingListener2, (Group)new EventBusTestFixture.GroupB());
            this.eventBus().register((EventListener)countingListener3, (Group)new EventBusTestFixture.GroupC());
            this.eventBus2().register((EventListener)countingListener1, (Group)new EventBusTestFixture.GroupA());
            this.eventBus2().register((EventListener)countingListener2, (Group)new EventBusTestFixture.GroupB());
            this.eventBus2().register((EventListener)countingListener3, (Group)new EventBusTestFixture.GroupC());
            int totalGlobalRegistrations = 3;
            ConcurrentTestRunner.builder().operation((threadNumber, operationNumber) -> this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block()).threadCount(10).operationCount(30).runSuccessfullyWithin(FIVE_SECONDS);
            AWAIT_CONDITION.untilAsserted(() -> Assertions.assertThat((int)EventBusConcurrentTestContract.totalEventsReceived((ImmutableList<EventBusTestFixture.EventListenerCountingSuccessfulExecution>)ImmutableList.of((Object)countingListener1, (Object)countingListener2, (Object)countingListener3))).isEqualTo(totalGlobalRegistrations * 300));
        }

        @Test
        default public void concurrentDispatchKeyShouldDeliverAllEventsToListenersWithMultipleEventBus() throws Exception {
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener1 = EventBusConcurrentTestContract.newCountingListener();
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener2 = EventBusConcurrentTestContract.newCountingListener();
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener3 = EventBusConcurrentTestContract.newCountingListener();
            Mono.from((Publisher)this.eventBus().register((EventListener)countingListener1, EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus().register((EventListener)countingListener2, EventBusTestFixture.KEY_2)).block();
            Mono.from((Publisher)this.eventBus().register((EventListener)countingListener3, EventBusTestFixture.KEY_3)).block();
            Mono.from((Publisher)this.eventBus2().register((EventListener)countingListener1, EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus2().register((EventListener)countingListener2, EventBusTestFixture.KEY_2)).block();
            Mono.from((Publisher)this.eventBus2().register((EventListener)countingListener3, EventBusTestFixture.KEY_3)).block();
            int totalKeyListenerRegistrations = 3;
            int totalEventBus = 2;
            ConcurrentTestRunner.builder().operation((threadNumber, operationNumber) -> this.eventBus().dispatch(EventBusTestFixture.EVENT, ALL_KEYS).block()).threadCount(10).operationCount(30).runSuccessfullyWithin(FIVE_SECONDS);
            AWAIT_CONDITION.untilAsserted(() -> Assertions.assertThat((int)EventBusConcurrentTestContract.totalEventsReceived((ImmutableList<EventBusTestFixture.EventListenerCountingSuccessfulExecution>)ImmutableList.of((Object)countingListener1, (Object)countingListener2, (Object)countingListener3))).isEqualTo(totalKeyListenerRegistrations * totalEventBus * 300));
        }

        @Test
        default public void concurrentDispatchShouldDeliverAllEventsToListenersWithMultipleEventBus() throws Exception {
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener1 = EventBusConcurrentTestContract.newCountingListener();
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener2 = EventBusConcurrentTestContract.newCountingListener();
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener3 = EventBusConcurrentTestContract.newCountingListener();
            this.eventBus2().register((EventListener)countingListener1, EventDeadLettersContract.GROUP_A);
            this.eventBus2().register((EventListener)countingListener2, (Group)new EventBusTestFixture.GroupB());
            this.eventBus2().register((EventListener)countingListener3, (Group)new EventBusTestFixture.GroupC());
            int totalGlobalRegistrations = 3;
            int totalEventDeliveredGlobally = totalGlobalRegistrations * 300;
            Mono.from((Publisher)this.eventBus().register((EventListener)countingListener1, EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus().register((EventListener)countingListener2, EventBusTestFixture.KEY_2)).block();
            Mono.from((Publisher)this.eventBus2().register((EventListener)countingListener1, EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus2().register((EventListener)countingListener2, EventBusTestFixture.KEY_2)).block();
            Mono.from((Publisher)this.eventBus3().register((EventListener)countingListener3, EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus3().register((EventListener)countingListener3, EventBusTestFixture.KEY_2)).block();
            int totalKeyListenerRegistrations = 2;
            int totalEventBus = 3;
            int totalEventDeliveredByKeys = totalKeyListenerRegistrations * totalEventBus * 300;
            ConcurrentTestRunner.builder().operation((threadNumber, operationNumber) -> this.eventBus().dispatch(EventBusTestFixture.EVENT, ALL_KEYS).block()).threadCount(10).operationCount(30).runSuccessfullyWithin(FIVE_SECONDS);
            AWAIT_CONDITION.untilAsserted(() -> Assertions.assertThat((int)EventBusConcurrentTestContract.totalEventsReceived((ImmutableList<EventBusTestFixture.EventListenerCountingSuccessfulExecution>)ImmutableList.of((Object)countingListener1, (Object)countingListener2, (Object)countingListener3))).isEqualTo(totalEventDeliveredGlobally + totalEventDeliveredByKeys));
        }
    }

    public static interface SingleEventBusConcurrentContract
    extends EventBusContract {
        @Test
        default public void concurrentDispatchGroupShouldDeliverAllEventsToListenersWithSingleEventBus() throws Exception {
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener1 = EventBusConcurrentTestContract.newCountingListener();
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener2 = EventBusConcurrentTestContract.newCountingListener();
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener3 = EventBusConcurrentTestContract.newCountingListener();
            this.eventBus().register((EventListener)countingListener1, (Group)new EventBusTestFixture.GroupA());
            this.eventBus().register((EventListener)countingListener2, (Group)new EventBusTestFixture.GroupB());
            this.eventBus().register((EventListener)countingListener3, (Group)new EventBusTestFixture.GroupC());
            int totalGlobalRegistrations = 3;
            ConcurrentTestRunner.builder().operation((threadNumber, operationNumber) -> this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block()).threadCount(10).operationCount(30).runSuccessfullyWithin(FIVE_SECONDS);
            AWAIT_CONDITION.untilAsserted(() -> Assertions.assertThat((int)EventBusConcurrentTestContract.totalEventsReceived((ImmutableList<EventBusTestFixture.EventListenerCountingSuccessfulExecution>)ImmutableList.of((Object)countingListener1, (Object)countingListener2, (Object)countingListener3))).isEqualTo(totalGlobalRegistrations * 300));
        }

        @Test
        default public void concurrentDispatchKeyShouldDeliverAllEventsToListenersWithSingleEventBus() throws Exception {
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener1 = EventBusConcurrentTestContract.newCountingListener();
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener2 = EventBusConcurrentTestContract.newCountingListener();
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener3 = EventBusConcurrentTestContract.newCountingListener();
            Mono.from((Publisher)this.eventBus().register((EventListener)countingListener1, EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus().register((EventListener)countingListener2, EventBusTestFixture.KEY_2)).block();
            Mono.from((Publisher)this.eventBus().register((EventListener)countingListener3, EventBusTestFixture.KEY_3)).block();
            int totalKeyListenerRegistrations = 3;
            int totalEventBus = 1;
            ConcurrentTestRunner.builder().operation((threadNumber, operationNumber) -> this.eventBus().dispatch(EventBusTestFixture.EVENT, ALL_KEYS).block()).threadCount(10).operationCount(30).runSuccessfullyWithin(FIVE_SECONDS);
            AWAIT_CONDITION.untilAsserted(() -> Assertions.assertThat((int)EventBusConcurrentTestContract.totalEventsReceived((ImmutableList<EventBusTestFixture.EventListenerCountingSuccessfulExecution>)ImmutableList.of((Object)countingListener1, (Object)countingListener2, (Object)countingListener3))).isEqualTo(totalKeyListenerRegistrations * totalEventBus * 300));
        }

        @Test
        default public void concurrentDispatchShouldDeliverAllEventsToListenersWithSingleEventBus() throws Exception {
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener1 = EventBusConcurrentTestContract.newCountingListener();
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener2 = EventBusConcurrentTestContract.newCountingListener();
            EventBusTestFixture.EventListenerCountingSuccessfulExecution countingListener3 = EventBusConcurrentTestContract.newCountingListener();
            this.eventBus().register((EventListener)countingListener1, (Group)new EventBusTestFixture.GroupA());
            this.eventBus().register((EventListener)countingListener2, (Group)new EventBusTestFixture.GroupB());
            this.eventBus().register((EventListener)countingListener3, (Group)new EventBusTestFixture.GroupC());
            int totalGlobalRegistrations = 3;
            int totalEventDeliveredGlobally = totalGlobalRegistrations * 300;
            Mono.from((Publisher)this.eventBus().register((EventListener)countingListener1, EventBusTestFixture.KEY_1)).block();
            Mono.from((Publisher)this.eventBus().register((EventListener)countingListener2, EventBusTestFixture.KEY_2)).block();
            Mono.from((Publisher)this.eventBus().register((EventListener)countingListener3, EventBusTestFixture.KEY_3)).block();
            int totalKeyListenerRegistrations = 3;
            int totalEventDeliveredByKeys = totalKeyListenerRegistrations * 300;
            ConcurrentTestRunner.builder().operation((threadNumber, operationNumber) -> this.eventBus().dispatch(EventBusTestFixture.EVENT, ALL_KEYS).block()).threadCount(10).operationCount(30).runSuccessfullyWithin(FIVE_SECONDS);
            AWAIT_CONDITION.untilAsserted(() -> Assertions.assertThat((int)EventBusConcurrentTestContract.totalEventsReceived((ImmutableList<EventBusTestFixture.EventListenerCountingSuccessfulExecution>)ImmutableList.of((Object)countingListener1, (Object)countingListener2, (Object)countingListener3))).isEqualTo(totalEventDeliveredGlobally + totalEventDeliveredByKeys));
        }
    }
}

