/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.james.events.Event;
import org.apache.james.events.EventBusContract;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.EventCollector;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

interface ErrorHandlingContract
extends EventBusContract {
    public EventDeadLetters deadLetter();

    default public EventCollector eventCollector() {
        return (EventCollector)Mockito.spy((Object)new EventCollector());
    }

    default public ThrowingListener throwingListener() {
        return new ThrowingListener();
    }

    @Test
    default public void retryingIsNotAppliedForKeyRegistrations() {
        EventCollector eventCollector = this.eventCollector();
        ((EventCollector)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)eventCollector)).event(EventBusTestFixture.EVENT);
        Mono.from((Publisher)this.eventBus().register((EventListener)eventCollector, EventBusTestFixture.KEY_1)).block();
        this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
        Assertions.assertThat(eventCollector.getEvents()).isEmpty();
    }

    @Test
    default public void listenerShouldReceiveWhenFailsLessThanMaxRetries() {
        EventCollector eventCollector = this.eventCollector();
        ((EventCollector)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doCallRealMethod().when((Object)eventCollector)).event(EventBusTestFixture.EVENT);
        this.eventBus().register((EventListener)eventCollector, (Group)EventBusTestFixture.GROUP_A);
        this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
        this.getSpeedProfile().shortWaitCondition().untilAsserted(() -> Assertions.assertThat(eventCollector.getEvents()).hasSize(1));
    }

    @Test
    default public void listenerShouldReceiveWhenFailsEqualsMaxRetries() {
        EventCollector eventCollector = this.eventCollector();
        ((EventCollector)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doCallRealMethod().when((Object)eventCollector)).event(EventBusTestFixture.EVENT);
        this.eventBus().register((EventListener)eventCollector, (Group)EventBusTestFixture.GROUP_A);
        this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
        this.getSpeedProfile().longWaitCondition().untilAsserted(() -> Assertions.assertThat(eventCollector.getEvents()).hasSize(1));
    }

    @Test
    default public void listenerShouldNotReceiveWhenFailsGreaterThanMaxRetries() throws Exception {
        EventCollector eventCollector = this.eventCollector();
        ((EventCollector)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doCallRealMethod().when((Object)eventCollector)).event(EventBusTestFixture.EVENT);
        this.eventBus().register((EventListener)eventCollector, (Group)EventBusTestFixture.GROUP_A);
        this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
        TimeUnit.SECONDS.sleep(1L);
        Assertions.assertThat(eventCollector.getEvents()).isEmpty();
    }

    @Test
    default public void exceedingMaxRetriesShouldStopConsumingFailedEvent() throws Exception {
        ThrowingListener throwingListener = this.throwingListener();
        this.eventBus().register((EventListener)throwingListener, (Group)EventBusTestFixture.GROUP_A);
        this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
        this.getSpeedProfile().shortWaitCondition().untilAsserted(() -> Assertions.assertThat((int)throwingListener.executionCount()).isEqualTo(4));
        Thread.sleep(this.getSpeedProfile().getShortWaitTime().toMillis());
        Assertions.assertThat((int)throwingListener.executionCount()).isEqualTo(4);
    }

    @Test
    default public void retriesBackOffShouldDelayByExponentialGrowth() {
        ThrowingListener throwingListener = this.throwingListener();
        this.eventBus().register((EventListener)throwingListener, (Group)EventBusTestFixture.GROUP_A);
        this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
        this.getSpeedProfile().shortWaitCondition().untilAsserted(() -> Assertions.assertThat((int)throwingListener.executionCount()).isEqualTo(4));
        SoftAssertions.assertSoftly(softly -> {
            List<Instant> timeElapsed = throwingListener.timeElapsed;
            softly.assertThat(timeElapsed).hasSize(EventBusTestFixture.RETRY_BACKOFF_CONFIGURATION.getMaxRetries() + 1);
            long minFirstDelayAfter = EventBusTestFixture.DEFAULT_FIRST_BACKOFF.toMillis();
            long minSecondDelayAfter = EventBusTestFixture.DEFAULT_FIRST_BACKOFF.toMillis() / 2L;
            long minThirdDelayAfter = EventBusTestFixture.DEFAULT_FIRST_BACKOFF.toMillis();
            softly.assertThat(timeElapsed.get(1)).isAfterOrEqualTo(timeElapsed.get(0).plusMillis(minFirstDelayAfter));
            softly.assertThat(timeElapsed.get(2)).isAfterOrEqualTo(timeElapsed.get(1).plusMillis(minSecondDelayAfter));
            softly.assertThat(timeElapsed.get(3)).isAfterOrEqualTo(timeElapsed.get(2).plusMillis(minThirdDelayAfter));
        });
    }

    @Test
    default public void retryingListenerCallingDispatchShouldNotFail() {
        AtomicBoolean firstExecution = new AtomicBoolean(true);
        AtomicBoolean successfulRetry = new AtomicBoolean(false);
        EventListener listener = event -> {
            if (event.getEventId().equals((Object)EventBusTestFixture.EVENT_ID)) {
                if (firstExecution.get()) {
                    firstExecution.set(false);
                    throw new RuntimeException();
                }
                this.eventBus().dispatch(EventBusTestFixture.EVENT_2, EventBusTestFixture.NO_KEYS).block();
                successfulRetry.set(true);
            }
        };
        this.eventBus().register(listener, (Group)EventBusTestFixture.GROUP_A);
        this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
        this.getSpeedProfile().shortWaitCondition().until(successfulRetry::get);
    }

    @Test
    default public void deadLettersIsNotAppliedForKeyRegistrations() throws Exception {
        EventCollector eventCollector = this.eventCollector();
        ((EventCollector)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doCallRealMethod().when((Object)eventCollector)).event(EventBusTestFixture.EVENT);
        Mono.from((Publisher)this.eventBus().register((EventListener)eventCollector, EventBusTestFixture.KEY_1)).block();
        this.eventBus().dispatch(EventBusTestFixture.EVENT, (Set)ImmutableSet.of((Object)EventBusTestFixture.KEY_1)).block();
        TimeUnit.SECONDS.sleep(1L);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(eventCollector.getEvents()).isEmpty();
            softly.assertThat(this.deadLetter().groupsWithFailedEvents().toIterable()).isEmpty();
        });
    }

    @Test
    default public void deadLetterShouldNotStoreWhenFailsLessThanMaxRetries() {
        EventCollector eventCollector = this.eventCollector();
        ((EventCollector)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doCallRealMethod().when((Object)eventCollector)).event(EventBusTestFixture.EVENT);
        this.eventBus().register((EventListener)eventCollector, (Group)new EventBusTestFixture.GroupA());
        this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
        this.getSpeedProfile().shortWaitCondition().untilAsserted(() -> Assertions.assertThat(eventCollector.getEvents()).hasSize(1));
        Assertions.assertThat((Iterable)this.deadLetter().groupsWithFailedEvents().toIterable()).isEmpty();
    }

    @Test
    default public void deadLetterShouldStoreWhenDispatchFailsGreaterThanMaxRetries() {
        EventCollector eventCollector = this.eventCollector();
        ((EventCollector)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doCallRealMethod().when((Object)eventCollector)).event(EventBusTestFixture.EVENT);
        this.eventBus().register((EventListener)eventCollector, (Group)EventBusTestFixture.GROUP_A);
        this.eventBus().dispatch(EventBusTestFixture.EVENT, EventBusTestFixture.NO_KEYS).block();
        this.getSpeedProfile().longWaitCondition().untilAsserted(() -> Assertions.assertThat((Iterable)this.deadLetter().failedIds((Group)EventBusTestFixture.GROUP_A).flatMap(insertionId -> this.deadLetter().failedEvent((Group)EventBusTestFixture.GROUP_A, insertionId)).toIterable()).containsOnly((Object[])new Event[]{EventBusTestFixture.EVENT}));
        Assertions.assertThat(eventCollector.getEvents()).isEmpty();
    }

    @Test
    default public void deadLetterShouldStoreWhenRedeliverFailsGreaterThanMaxRetries() {
        EventCollector eventCollector = this.eventCollector();
        ((EventCollector)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doCallRealMethod().when((Object)eventCollector)).event(EventBusTestFixture.EVENT);
        this.eventBus().register((EventListener)eventCollector, (Group)EventBusTestFixture.GROUP_A);
        this.eventBus().reDeliver((Group)EventBusTestFixture.GROUP_A, EventBusTestFixture.EVENT).block();
        this.getSpeedProfile().longWaitCondition().untilAsserted(() -> Assertions.assertThat((Iterable)this.deadLetter().failedIds((Group)EventBusTestFixture.GROUP_A).flatMap(insertionId -> this.deadLetter().failedEvent((Group)EventBusTestFixture.GROUP_A, insertionId)).toIterable()).containsOnly((Object[])new Event[]{EventBusTestFixture.EVENT}));
        Assertions.assertThat(eventCollector.getEvents()).isEmpty();
    }

    @Disabled(value="JAMES-2907 redeliver should work as initial dispatch")
    @Test
    default public void retryShouldDeliverAsManyTimesAsInitialDeliveryAttempt() {
        EventCollector eventCollector = this.eventCollector();
        ((EventCollector)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doThrow(new Throwable[]{new RuntimeException()}).doCallRealMethod().when((Object)eventCollector)).event(EventBusTestFixture.EVENT);
        this.eventBus().register((EventListener)eventCollector, (Group)EventBusTestFixture.GROUP_A);
        this.eventBus().reDeliver((Group)EventBusTestFixture.GROUP_A, EventBusTestFixture.EVENT).block();
        this.getSpeedProfile().longWaitCondition().untilAsserted(() -> Assertions.assertThat(eventCollector.getEvents()).isNotEmpty());
    }

    @Test
    default public void redeliverShouldNotSendEventsToKeyListeners() {
        EventCollector eventCollector = this.eventCollector();
        EventCollector eventCollector2 = this.eventCollector();
        this.eventBus().register((EventListener)eventCollector, (Group)EventBusTestFixture.GROUP_A);
        Mono.from((Publisher)this.eventBus().register((EventListener)eventCollector2, EventBusTestFixture.KEY_1)).block();
        this.eventBus().reDeliver((Group)EventBusTestFixture.GROUP_A, EventBusTestFixture.EVENT).block();
        this.getSpeedProfile().longWaitCondition().untilAsserted(() -> Assertions.assertThat(eventCollector.getEvents()).hasSize(1));
        Assertions.assertThat(eventCollector2.getEvents()).isEmpty();
    }

    public static class ThrowingListener
    implements EventListener {
        private final List<Instant> timeElapsed = new ArrayList<Instant>();

        private ThrowingListener() {
        }

        public boolean isHandling(Event event) {
            return true;
        }

        public void event(Event event) {
            this.timeElapsed.add(Instant.now());
            throw new RuntimeException("throw to trigger reactor retry");
        }

        public int executionCount() {
            return this.timeElapsed.size();
        }
    }
}

