/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.distributed;

import com.google.inject.Module;
import java.io.IOException;
import java.util.List;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.DockerOpenSearchExtension;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.backends.opensearch.OpenSearchConfiguration;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.jmap.rfc8621.contract.ThreadGetContract;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.opensearch.MailboxIndexCreationUtil;
import org.apache.james.mailbox.opensearch.MailboxOpenSearchConstants;
import org.apache.james.mailbox.opensearch.query.CriterionConverter;
import org.apache.james.mailbox.opensearch.query.QueryConverter;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;

public class DistributedThreadGetMethodTest
implements ThreadGetContract {
    private static final ConditionFactory CALMLY_AWAIT = Awaitility.with().pollInterval(Durations.ONE_HUNDRED_MILLISECONDS).and().pollDelay(Durations.ONE_HUNDRED_MILLISECONDS).await();
    private final QueryConverter queryConverter = new QueryConverter(new CriterionConverter());
    private ReactorOpenSearchClient client;
    @RegisterExtension
    org.apache.james.backends.opensearch.DockerOpenSearchExtension openSearch = new org.apache.james.backends.opensearch.DockerOpenSearchExtension();
    @RegisterExtension
    JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig()).searchConfiguration(SearchConfiguration.openSearch()).build()).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new RabbitMQExtension()).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).server(configuration -> CassandraRabbitMQJamesServerMain.createServer((CassandraRabbitMQJamesConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule()})).build();

    @AfterEach
    void tearDown() throws IOException {
        this.client.close();
    }

    public void awaitMessageCount(List<MailboxId> mailboxIds, SearchQuery query, long messageCount) {
        this.awaitForOpenSearch(this.queryConverter.from(mailboxIds, query), messageCount);
    }

    public void initOpenSearchClient() {
        this.client = MailboxIndexCreationUtil.prepareDefaultClient((ReactorOpenSearchClient)this.openSearch.getDockerOpenSearch().clientProvider().get(), (OpenSearchConfiguration)this.openSearch.getDockerOpenSearch().configuration());
    }

    private void awaitForOpenSearch(Query query, long totalHits) {
        CALMLY_AWAIT.atMost(Durations.TEN_SECONDS).untilAsserted(() -> Assertions.assertThat((long)((SearchResponse)this.client.search(new SearchRequest.Builder().index(MailboxOpenSearchConstants.DEFAULT_MAILBOX_INDEX.getValue(), new String[0]).query(query).build()).block()).hits().total().value()).isEqualTo(totalHits));
    }
}

