/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.distributed;

import com.google.inject.Module;
import java.io.IOException;
import java.util.List;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.DockerElasticSearchExtension;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.backends.es.v7.ElasticSearchConfiguration;
import org.apache.james.backends.es.v7.ReactorElasticSearchClient;
import org.apache.james.jmap.rfc8621.contract.ThreadGetContract;
import org.apache.james.mailbox.elasticsearch.v7.MailboxElasticSearchConstants;
import org.apache.james.mailbox.elasticsearch.v7.MailboxIndexCreationUtil;
import org.apache.james.mailbox.elasticsearch.v7.query.CriterionConverter;
import org.apache.james.mailbox.elasticsearch.v7.query.QueryConverter;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.extension.RegisterExtension;

public class DistributedThreadGetMethodTest
implements ThreadGetContract {
    private static final ConditionFactory CALMLY_AWAIT = Awaitility.with().pollInterval(Durations.ONE_HUNDRED_MILLISECONDS).and().pollDelay(Durations.ONE_HUNDRED_MILLISECONDS).await();
    private final QueryConverter queryConverter = new QueryConverter(new CriterionConverter());
    private ReactorElasticSearchClient client;
    @RegisterExtension
    org.apache.james.backends.es.v7.DockerElasticSearchExtension elasticSearch = new org.apache.james.backends.es.v7.DockerElasticSearchExtension();
    @RegisterExtension
    JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig()).searchConfiguration(SearchConfiguration.elasticSearch()).build()).extension((GuiceModuleTestExtension)new DockerElasticSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new RabbitMQExtension()).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).server(configuration -> CassandraRabbitMQJamesServerMain.createServer((CassandraRabbitMQJamesConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule()})).build();

    @AfterEach
    void tearDown() throws IOException {
        this.client.close();
    }

    public void awaitMessageCount(List<MailboxId> mailboxIds, SearchQuery query, long messageCount) {
        this.awaitForElasticSearch(this.queryConverter.from(mailboxIds, query), messageCount);
    }

    public void initElasticSearchClient() {
        this.client = MailboxIndexCreationUtil.prepareDefaultClient((ReactorElasticSearchClient)this.elasticSearch.getDockerElasticSearch().clientProvider().get(), (ElasticSearchConfiguration)this.elasticSearch.getDockerElasticSearch().configuration());
    }

    private void awaitForElasticSearch(QueryBuilder query, long totalHits) {
        CALMLY_AWAIT.atMost(Durations.TEN_SECONDS).untilAsserted(() -> Assertions.assertThat((long)((SearchResponse)this.client.search((SearchRequest)new SearchRequest((String[])new String[]{MailboxElasticSearchConstants.DEFAULT_MAILBOX_INDEX.getValue()}).source((SearchSourceBuilder)new SearchSourceBuilder().query((QueryBuilder)query)), (RequestOptions)RequestOptions.DEFAULT).block()).getHits().getTotalHits().value).isEqualTo(totalHits));
    }
}

