/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import java.net.URI;
import org.apache.james.blob.objectstorage.aws.DockerAwsS3;
import org.apache.james.blob.objectstorage.aws.Region;
import org.apache.james.util.Host;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class DockerAwsS3Container {
    private static final String AWS_S3_DOCKER_IMAGE = "zenko/cloudserver:8.2.6";
    private static final int AWS_S3_PORT = 8000;
    private static final int ONE_TIME = 1;
    public static final Region REGION = Region.of((String)software.amazon.awssdk.regions.Region.EU_WEST_1.id());
    public static final String ACCESS_KEY_ID = "newAccessKey";
    public static final String SECRET_ACCESS_KEY = "newSecretKey";
    private final GenericContainer<?> awsS3Container = new GenericContainer("zenko/cloudserver:8.2.6");
    private DockerAwsS3 dockerAwsS3;

    public DockerAwsS3Container() {
        this.awsS3Container.withExposedPorts(new Integer[]{8000}).withEnv("S3BACKEND", "mem").withEnv("SCALITY_ACCESS_KEY_ID", ACCESS_KEY_ID).withEnv("SCALITY_SECRET_ACCESS_KEY", SECRET_ACCESS_KEY).withEnv("LOG_LEVEL", "trace").withEnv("REMOTE_MANAGEMENT_DISABLE", "1").waitingFor((WaitStrategy)Wait.forLogMessage((String)".*\"message\":\"server started\".*\\n", (int)1));
    }

    public void start() {
        this.awsS3Container.start();
        this.dockerAwsS3 = new DockerAwsS3(URI.create("http://" + this.getHost().asString() + "/"), REGION);
    }

    public void stop() {
        this.awsS3Container.stop();
    }

    public Host getHost() {
        return Host.from((String)this.getIp(), (int)this.getPort());
    }

    public String getIp() {
        return this.awsS3Container.getContainerIpAddress();
    }

    public int getPort() {
        return this.awsS3Container.getMappedPort(8000);
    }

    public URI getEndpoint() {
        return URI.create("http://" + this.getIp() + ":" + this.getPort() + "/");
    }

    public DockerAwsS3 dockerAwsS3() {
        return this.dockerAwsS3;
    }

    public GenericContainer<?> getRawContainer() {
        return this.awsS3Container;
    }
}

