/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreContract;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.objectstorage.aws.AwsS3AuthConfiguration;
import org.apache.james.blob.objectstorage.aws.DockerAwsS3Container;
import org.apache.james.blob.objectstorage.aws.DockerAwsS3Extension;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreConfiguration;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreDAO;
import org.apache.james.server.blob.deduplication.BlobStoreFactory;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={DockerAwsS3Extension.class})
class S3NamespaceTest
implements BlobStoreContract {
    private static BlobStore testee;
    private static S3BlobStoreDAO s3BlobStoreDAO;

    S3NamespaceTest() {
    }

    @BeforeAll
    static void setUpClass(DockerAwsS3Container dockerAwsS3) {
        AwsS3AuthConfiguration authConfiguration = AwsS3AuthConfiguration.builder().endpoint(dockerAwsS3.getEndpoint()).accessKeyId("newAccessKey").secretKey("newSecretKey").build();
        S3BlobStoreConfiguration s3Configuration = S3BlobStoreConfiguration.builder().authConfiguration(authConfiguration).region(dockerAwsS3.dockerAwsS3().region()).defaultBucketName(BucketName.of((String)"namespace")).build();
        HashBlobId.Factory blobIdFactory = new HashBlobId.Factory();
        s3BlobStoreDAO = new S3BlobStoreDAO(s3Configuration, (BlobId.Factory)blobIdFactory);
        testee = BlobStoreFactory.builder().blobStoreDAO((BlobStoreDAO)s3BlobStoreDAO).blobIdFactory((BlobId.Factory)blobIdFactory).bucket(BucketName.of((String)"namespace")).passthrough();
    }

    @AfterEach
    void tearDown() {
        s3BlobStoreDAO.deleteAllBuckets().block();
    }

    @AfterAll
    static void tearDownClass() {
        s3BlobStoreDAO.close();
    }

    public BlobStore testee() {
        return testee;
    }

    public BlobId.Factory blobIdFactory() {
        return new HashBlobId.Factory();
    }
}

