/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.IntStream;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BlobStoreDAOContract;
import org.apache.james.blob.api.BlobStoreDAOFixture;
import org.apache.james.blob.api.TestBlobId;
import org.apache.james.blob.objectstorage.aws.AwsS3AuthConfiguration;
import org.apache.james.blob.objectstorage.aws.DockerAwsS3Container;
import org.apache.james.blob.objectstorage.aws.DockerAwsS3Extension;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreConfiguration;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreDAO;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ExtendWith(value={DockerAwsS3Extension.class})
public class S3BlobStoreDAOTest
implements BlobStoreDAOContract {
    private static S3BlobStoreDAO testee;

    @BeforeAll
    static void setUp(DockerAwsS3Container dockerAwsS3) {
        AwsS3AuthConfiguration authConfiguration = AwsS3AuthConfiguration.builder().endpoint(dockerAwsS3.getEndpoint()).accessKeyId("newAccessKey").secretKey("newSecretKey").build();
        S3BlobStoreConfiguration s3Configuration = S3BlobStoreConfiguration.builder().authConfiguration(authConfiguration).region(dockerAwsS3.dockerAwsS3().region()).build();
        testee = new S3BlobStoreDAO(s3Configuration, (BlobId.Factory)new TestBlobId.Factory());
    }

    @AfterEach
    void tearDown() {
        testee.deleteAllBuckets().block();
    }

    @AfterAll
    static void tearDownClass() {
        testee.close();
    }

    public BlobStoreDAO testee() {
        return testee;
    }

    @Test
    void listingManyBlobsShouldSucceedWhenExceedingPageSize() {
        BlobStoreDAO store = this.testee();
        int count = 1500;
        Flux.range((int)0, (int)1500).flatMap(i -> store.save(BlobStoreDAOFixture.TEST_BUCKET_NAME, (BlobId)new TestBlobId("test-blob-id-" + i), ByteSource.wrap((byte[])BlobStoreDAOFixture.ELEVEN_KILOBYTES))).blockLast();
        Assertions.assertThat((Long)((Long)Flux.from((Publisher)this.testee().listBlobs(BlobStoreDAOFixture.TEST_BUCKET_NAME)).count().block())).isEqualTo(1500L);
    }

    @Test
    void readShouldNotLeakHttpConnexionsForUnclosedStreams() {
        BlobStoreDAO store = this.testee();
        TestBlobId blobId = new TestBlobId("id");
        Mono.from((Publisher)store.save(BlobStoreDAOFixture.TEST_BUCKET_NAME, (BlobId)blobId, ByteSource.wrap((byte[])BlobStoreDAOFixture.ELEVEN_KILOBYTES))).block();
        Assertions.assertThatCode(() -> IntStream.range(0, 256).forEach(i -> {
            InputStream inputStream = store.read(BlobStoreDAOFixture.TEST_BUCKET_NAME, (BlobId)blobId);
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).doesNotThrowAnyException();
    }
}

