/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import java.util.Optional;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.objectstorage.aws.BucketNameResolver;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class BucketNameResolverTest {
    BucketNameResolverTest() {
    }

    @Test
    void resolveShouldThrowWhenNullBucketName() {
        BucketNameResolver resolver = BucketNameResolver.builder().noPrefix().noNamespace().build();
        Assertions.assertThatThrownBy(() -> resolver.resolve(null)).isInstanceOf(NullPointerException.class);
    }

    @Nested
    class BothArePresent {
        BothArePresent() {
        }

        @ParameterizedTest
        @ValueSource(strings={"namespace", "any", "bucketPrefix-aaa", "bucketPrefix-"})
        void withShouldAddNewValuesInSet(String bucketNameString) {
            BucketNameResolver resolver = BucketNameResolver.builder().prefix("bucketPrefix-").namespace(BucketName.of((String)"namespace")).build();
            BucketName bucketName = BucketName.of((String)bucketNameString);
            Assertions.assertThat((Optional)resolver.unresolve(resolver.resolve(bucketName))).contains((Object)bucketName);
        }

        @Test
        void resolveShouldReturnPassedValueWithPrefix() {
            BucketNameResolver resolver = BucketNameResolver.builder().prefix("bucketPrefix-").namespace(BucketName.of((String)"namespace")).build();
            Assertions.assertThat((Object)resolver.resolve(BucketName.of((String)"bucketName"))).isEqualTo((Object)BucketName.of((String)"bucketPrefix-bucketName"));
        }

        @Test
        void resolveShouldReturnNamespaceWhenPassingNamespace() {
            BucketNameResolver resolver = BucketNameResolver.builder().prefix("bucketPrefix-").namespace(BucketName.of((String)"namespace")).build();
            Assertions.assertThat((Object)resolver.resolve(BucketName.of((String)"namespace"))).isEqualTo((Object)BucketName.of((String)"namespace"));
        }

        @Test
        void unresolveShouldFilterValuesWithoutPrefix() {
            BucketNameResolver resolver = BucketNameResolver.builder().prefix("bucketPrefix-").namespace(BucketName.of((String)"namespace")).build();
            Assertions.assertThat((Optional)resolver.unresolve(BucketName.of((String)"bucketName"))).isEmpty();
        }

        @Test
        void unresolveShouldRemovePrefix() {
            BucketNameResolver resolver = BucketNameResolver.builder().prefix("bucketPrefix-").namespace(BucketName.of((String)"namespace")).build();
            Assertions.assertThat((Optional)resolver.unresolve(BucketName.of((String)"bucketPrefix-bucketName"))).contains((Object)BucketName.of((String)"bucketName"));
        }

        @Test
        void unresolveShouldReturnNamespaceWhenPassingNamespace() {
            BucketNameResolver resolver = BucketNameResolver.builder().prefix("bucketPrefix-").namespace(BucketName.of((String)"namespace")).build();
            Assertions.assertThat((Optional)resolver.unresolve(BucketName.of((String)"namespace"))).contains((Object)BucketName.of((String)"namespace"));
        }
    }

    @Nested
    class BothAreEmpty {
        BothAreEmpty() {
        }

        @ParameterizedTest
        @ValueSource(strings={"namespace", "any", "bucketPrefix-aaa", "bucketPrefix-"})
        void withShouldAddNewValuesInSet(String bucketNameString) {
            BucketNameResolver resolver = BucketNameResolver.builder().noPrefix().noNamespace().build();
            BucketName bucketName = BucketName.of((String)bucketNameString);
            Assertions.assertThat((Optional)resolver.unresolve(resolver.resolve(bucketName))).contains((Object)bucketName);
        }

        @Test
        void resolveShouldReturnPassedValue() {
            BucketNameResolver resolver = BucketNameResolver.builder().noPrefix().noNamespace().build();
            Assertions.assertThat((Object)resolver.resolve(BucketName.of((String)"bucketName"))).isEqualTo((Object)BucketName.of((String)"bucketName"));
        }

        @Test
        void unresolveShouldReturnPassedValue() {
            BucketNameResolver resolver = BucketNameResolver.builder().noPrefix().noNamespace().build();
            Assertions.assertThat((Optional)resolver.unresolve(BucketName.of((String)"bucketName"))).contains((Object)BucketName.of((String)"bucketName"));
        }
    }

    @Nested
    class EmptyNamespace {
        EmptyNamespace() {
        }

        @ParameterizedTest
        @ValueSource(strings={"namespace", "any", "bucketPrefix-aaa", "bucketPrefix-"})
        void withShouldAddNewValuesInSet(String bucketNameString) {
            BucketNameResolver resolver = BucketNameResolver.builder().prefix("bucketPrefix-").noNamespace().build();
            BucketName bucketName = BucketName.of((String)bucketNameString);
            Assertions.assertThat((Optional)resolver.unresolve(resolver.resolve(bucketName))).contains((Object)bucketName);
        }

        @Test
        void resolveShouldReturnPassedValueWithPrefix() {
            BucketNameResolver resolver = BucketNameResolver.builder().prefix("bucketPrefix-").noNamespace().build();
            Assertions.assertThat((Object)resolver.resolve(BucketName.of((String)"bucketName"))).isEqualTo((Object)BucketName.of((String)"bucketPrefix-bucketName"));
        }

        @Test
        void unresolveShouldReturnPassedValueWithPrefix() {
            BucketNameResolver resolver = BucketNameResolver.builder().prefix("bucketPrefix-").noNamespace().build();
            Assertions.assertThat((Optional)resolver.unresolve(BucketName.of((String)"bucketPrefix-bucketName"))).contains((Object)BucketName.of((String)"bucketName"));
        }

        @Test
        void unresolveShouldFilterValuesWithoutPrefix() {
            BucketNameResolver resolver = BucketNameResolver.builder().prefix("bucketPrefix-").noNamespace().build();
            Assertions.assertThat((Optional)resolver.unresolve(BucketName.of((String)"bucketName"))).isEmpty();
        }
    }

    @Nested
    class EmptyPrefix {
        EmptyPrefix() {
        }

        @ParameterizedTest
        @ValueSource(strings={"namespace", "any", "bucketPrefix-aaa", "bucketPrefix-"})
        void withShouldAddNewValuesInSet(String bucketNameString) {
            BucketNameResolver resolver = BucketNameResolver.builder().noPrefix().namespace(BucketName.of((String)"namespace")).build();
            BucketName bucketName = BucketName.of((String)bucketNameString);
            Assertions.assertThat((Optional)resolver.unresolve(resolver.resolve(bucketName))).contains((Object)bucketName);
        }

        @Test
        void resolveShouldReturnPassedValue() {
            BucketNameResolver resolver = BucketNameResolver.builder().noPrefix().namespace(BucketName.of((String)"namespace")).build();
            Assertions.assertThat((Object)resolver.resolve(BucketName.of((String)"bucketName"))).isEqualTo((Object)BucketName.of((String)"bucketName"));
        }

        @Test
        void resolveShouldReturnValueWhenNamespace() {
            BucketNameResolver resolver = BucketNameResolver.builder().noPrefix().namespace(BucketName.of((String)"namespace")).build();
            Assertions.assertThat((Object)resolver.resolve(BucketName.of((String)"namespace"))).isEqualTo((Object)BucketName.of((String)"namespace"));
        }

        @Test
        void unresolveShouldReturnPassedValue() {
            BucketNameResolver resolver = BucketNameResolver.builder().noPrefix().namespace(BucketName.of((String)"namespace")).build();
            Assertions.assertThat((Optional)resolver.unresolve(BucketName.of((String)"bucketName"))).contains((Object)BucketName.of((String)"bucketName"));
        }

        @Test
        void unresolveShouldReturnValueWhenNamespace() {
            BucketNameResolver resolver = BucketNameResolver.builder().noPrefix().namespace(BucketName.of((String)"namespace")).build();
            Assertions.assertThat((Optional)resolver.unresolve(BucketName.of((String)"namespace"))).contains((Object)BucketName.of((String)"namespace"));
        }
    }
}

