/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.export.file;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.api.ObjectStoreException;
import org.apache.james.blob.export.api.FileExtension;
import org.apache.james.blob.export.file.FileSystemExtension;
import org.apache.james.blob.export.file.LocalFileBlobExportMechanism;
import org.apache.james.blob.memory.MemoryBlobStoreFactory;
import org.apache.james.core.MailAddress;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMailContext;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@ExtendWith(value={FileSystemExtension.class})
class LocalFileBlobExportMechanismTest {
    private static final String BLOB_CONTENT = "blob_content";
    private static final String JAMES_HOST = "james-host";
    private BlobStore blobStore;
    private FakeMailContext mailetContext;
    private LocalFileBlobExportMechanism testee;

    LocalFileBlobExportMechanismTest() {
    }

    @BeforeEach
    void setUp(FileSystem fileSystem) throws Exception {
        this.mailetContext = FakeMailContext.builder().postmaster(MailAddressFixture.POSTMASTER_AT_JAMES).build();
        this.blobStore = MemoryBlobStoreFactory.builder().blobIdFactory((BlobId.Factory)new HashBlobId.Factory()).defaultBucketName().passthrough();
        InetAddress localHost = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)localHost.getHostName()).thenReturn((Object)JAMES_HOST);
        DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
        Mockito.when((Object)dnsService.getLocalHost()).thenReturn((Object)localHost);
        this.testee = new LocalFileBlobExportMechanism((MailetContext)this.mailetContext, this.blobStore, fileSystem, dnsService, LocalFileBlobExportMechanism.Configuration.DEFAULT_CONFIGURATION);
    }

    @Test
    void exportingBlobShouldSendAMail() {
        BlobId blobId = (BlobId)Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), BLOB_CONTENT, BlobStore.StoragePolicy.LOW_COST)).block();
        String explanation = "The content of a deleted message vault had been shared with you.";
        this.testee.blobId(blobId).with(MailAddressFixture.RECIPIENT1).explanation(explanation).noFileCustomPrefix().noFileExtension().export();
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)this.mailetContext.getSentMails()).hasSize(1)).element(0)).satisfies(new ThrowingConsumer[]{sentMail -> {
            try {
                Assertions.assertThat((Object)sentMail.getSender()).isEqualTo((Object)MailAddressFixture.POSTMASTER_AT_JAMES);
                Assertions.assertThat((Collection)sentMail.getRecipients()).containsExactly((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1});
                Assertions.assertThat((Object[])sentMail.getMsg().getFrom()).contains((Object[])new Address[]{new InternetAddress(MailAddressFixture.POSTMASTER_AT_JAMES.asString())});
                Assertions.assertThat((Object[])sentMail.getMsg().getRecipients(Message.RecipientType.TO)).contains((Object[])new Address[]{new InternetAddress(MailAddressFixture.RECIPIENT1.asString())});
                Assertions.assertThat((String)sentMail.getMsg().getSubject()).isEqualTo("Some content had had just been exported");
                String mailContent = MimeMessageUtil.asString((MimeMessage)sentMail.getMsg());
                Assertions.assertThat((String)mailContent).contains(new CharSequence[]{explanation});
                Assertions.assertThat((String)mailContent).contains(new CharSequence[]{"The content of this blob can be read directly on James host filesystem (james-host) in this file: "});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }});
    }

    @Test
    void exportingBlobShouldCreateAFileWithTheCorrespondingContent(FileSystem fileSystem) {
        BlobId blobId = (BlobId)Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), BLOB_CONTENT, BlobStore.StoragePolicy.LOW_COST)).block();
        this.testee.blobId(blobId).with(MailAddressFixture.RECIPIENT1).explanation("The content of a deleted message vault had been shared with you.").noFileCustomPrefix().noFileExtension().export();
        ((ObjectAssert)Assertions.assertThat((List)this.mailetContext.getSentMails()).element(0)).satisfies(new ThrowingConsumer[]{sentMail -> {
            try {
                String absoluteUrl = sentMail.getMsg().getHeader("corresponding-file")[0];
                Assertions.assertThat((InputStream)new FileInputStream(absoluteUrl)).hasSameContentAs(IOUtils.toInputStream((String)BLOB_CONTENT, (Charset)StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }});
    }

    @Test
    void shareShouldFailWhenBlobDoesNotExist() {
        HashBlobId blobId = new HashBlobId.Factory().forPayload("not existing".getBytes(StandardCharsets.UTF_8));
        Assertions.assertThatThrownBy(() -> this.lambda$shareShouldFailWhenBlobDoesNotExist$2((BlobId)blobId)).isInstanceOf(ObjectStoreException.class);
    }

    @Test
    void exportingBlobShouldCreateAFileWithoutExtensionWhenNotDeclaringExtension() {
        BlobId blobId = (BlobId)Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), BLOB_CONTENT, BlobStore.StoragePolicy.LOW_COST)).block();
        this.testee.blobId(blobId).with(MailAddressFixture.RECIPIENT1).explanation("The content of a deleted message vault had been shared with you.").noFileCustomPrefix().noFileExtension().export();
        ((ObjectAssert)Assertions.assertThat((List)this.mailetContext.getSentMails()).element(0)).satisfies(new ThrowingConsumer[]{sentMail -> {
            try {
                String fileUrl = sentMail.getMsg().getHeader("corresponding-file")[0];
                Assertions.assertThat((String)FilenameUtils.getExtension((String)fileUrl)).isEmpty();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }});
    }

    @Test
    void exportingBlobShouldCreateAFileWithExtensionWhenDeclaringExtension() {
        BlobId blobId = (BlobId)Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), BLOB_CONTENT, BlobStore.StoragePolicy.LOW_COST)).block();
        this.testee.blobId(blobId).with(MailAddressFixture.RECIPIENT1).explanation("The content of a deleted message vault had been shared with you.").noFileCustomPrefix().fileExtension(FileExtension.ZIP).export();
        ((ObjectAssert)Assertions.assertThat((List)this.mailetContext.getSentMails()).element(0)).satisfies(new ThrowingConsumer[]{sentMail -> {
            try {
                String fileUrl = sentMail.getMsg().getHeader("corresponding-file")[0];
                String fileExtensionInString = FilenameUtils.getExtension((String)fileUrl);
                Assertions.assertThat((Object)FileExtension.of((String)fileExtensionInString)).isEqualTo((Object)FileExtension.ZIP);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }});
    }

    @Test
    void exportingBlobShouldCreateAFileWithPrefixWhenDeclaringPrefix() {
        BlobId blobId = (BlobId)Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), BLOB_CONTENT, BlobStore.StoragePolicy.LOW_COST)).block();
        String filePrefix = "deleted-message-of-bob@james.org";
        this.testee.blobId(blobId).with(MailAddressFixture.RECIPIENT1).explanation("The content of a deleted message vault had been shared with you.").filePrefix(filePrefix).fileExtension(FileExtension.ZIP).export();
        ((ObjectAssert)Assertions.assertThat((List)this.mailetContext.getSentMails()).element(0)).satisfies(new ThrowingConsumer[]{sentMail -> {
            try {
                String fileUrl = sentMail.getMsg().getHeader("corresponding-file")[0];
                Assertions.assertThat((String)FilenameUtils.getName((String)fileUrl)).startsWith((CharSequence)filePrefix);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }});
    }

    private /* synthetic */ void lambda$shareShouldFailWhenBlobDoesNotExist$2(BlobId blobId) throws Throwable {
        this.testee.blobId(blobId).with(MailAddressFixture.RECIPIENT1).explanation("The content of a deleted message vault had been shared with you.").noFileCustomPrefix().noFileExtension().export();
    }

    @Nested
    class ConfigurationTest {
        ConfigurationTest() {
        }

        @Test
        void shouldMatchBeanContract() {
            EqualsVerifier.forClass(LocalFileBlobExportMechanism.Configuration.class).verify();
        }

        @Test
        void fromShouldReturnEmptyWhenDirectoryIsMissing() {
            PropertiesConfiguration configuration = new PropertiesConfiguration();
            Assertions.assertThat((Optional)LocalFileBlobExportMechanism.Configuration.from((Configuration)configuration)).isEmpty();
        }

        @Test
        void fromShouldReturnEmptyWhenDirectoryIsNull() {
            PropertiesConfiguration configuration = new PropertiesConfiguration();
            configuration.addProperty("blob.export.localFile.directory", null);
            Assertions.assertThat((Optional)LocalFileBlobExportMechanism.Configuration.from((Configuration)configuration)).isEmpty();
        }

        @Test
        void fromShouldReturnConfigurationWhenDirectoryIsSpecified() {
            PropertiesConfiguration configuration = new PropertiesConfiguration();
            String exportDirectory = "file://var/localFileBlobExport";
            configuration.addProperty("blob.export.localFile.directory", (Object)exportDirectory);
            Assertions.assertThat((Optional)LocalFileBlobExportMechanism.Configuration.from((Configuration)configuration)).contains((Object)new LocalFileBlobExportMechanism.Configuration(exportDirectory));
        }
    }
}

