/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.export.file;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.james.blob.export.file.FileSystemExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;

class FileSystemExtensionTest {
    private static ExtensionContext DUMMY_EXTENSION_CONTEXT = null;
    @RegisterExtension
    static FileSystemExtension fileSystemExtension = new FileSystemExtension();

    FileSystemExtensionTest() {
    }

    @Nested
    class DeletingFileSystemBaseDir {
        DeletingFileSystemBaseDir() {
        }

        @Test
        void extensionShouldDeleteWhenTestDoesntCreateNewFiles() throws Exception {
            fileSystemExtension.afterAll(DUMMY_EXTENSION_CONTEXT);
            Assertions.assertThat((File)fileSystemExtension.getFileSystem().getBasedir()).doesNotExist();
        }

        @Test
        void extensionShouldDeleteWhenTestCreateNewFiles() throws Exception {
            File baseDir = fileSystemExtension.getFileSystem().getBasedir();
            FileUtils.forceMkdir((File)baseDir);
            File fileInsideBaseDir = new File(baseDir.getPath() + "/fileInsideBaseDir.temp");
            FileUtils.touch((File)fileInsideBaseDir);
            fileSystemExtension.afterAll(DUMMY_EXTENSION_CONTEXT);
            Assertions.assertThat((File)fileSystemExtension.getFileSystem().getBasedir()).doesNotExist();
        }
    }
}

