/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.export.file;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.apache.james.server.core.JamesServerResourceLoader;
import org.apache.james.server.core.filesystem.FileSystemImpl;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class FileSystemExtension
implements ParameterResolver,
BeforeAllCallback,
AfterAllCallback {
    private FileSystemImpl fileSystem;

    public void beforeAll(ExtensionContext context) {
        this.fileSystem = new FileSystemImpl((JamesDirectoriesProvider)new JamesServerResourceLoader("../testsFileSystemExtension/" + UUID.randomUUID()));
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.fileSystem.getBasedir().exists()) {
            FileUtils.forceDelete((File)this.fileSystem.getBasedir());
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == FileSystem.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.fileSystem;
    }

    @VisibleForTesting
    FileSystemImpl getFileSystem() {
        return this.fileSystem;
    }
}

