/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.export.api;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.blob.export.api.FileExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FileExtensionTest {
    FileExtensionTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(FileExtension.class).verify();
    }

    @Test
    void constructorShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> new FileExtension(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void constructorShouldThrowOnEmpty() {
        Assertions.assertThatThrownBy(() -> new FileExtension("")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void constructorShouldThrowOnBlank() {
        Assertions.assertThatThrownBy(() -> new FileExtension("  ")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void appendExtensionShouldThrowWhenPassingNullValue() {
        FileExtension fileExtension = new FileExtension("zip");
        Assertions.assertThatThrownBy(() -> fileExtension.appendExtension(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void appendExtensionShouldThrowWhenPassingEmptyStringValue() {
        FileExtension fileExtension = new FileExtension("zip");
        Assertions.assertThatThrownBy(() -> fileExtension.appendExtension("")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void appendExtensionShouldReturnValueEndsWithExtension() {
        FileExtension fileExtension = new FileExtension("tar.gz");
        Assertions.assertThat((String)fileExtension.appendExtension("/local/james")).endsWith((CharSequence)".tar.gz");
    }

    @Test
    void asFileSuffixShouldReturnDotAndExtension() {
        FileExtension fileExtension = new FileExtension("tar.gz");
        Assertions.assertThat((String)fileExtension.asFileSuffix()).isEqualTo(".tar.gz");
    }
}

