/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.export.api;

import java.util.Optional;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.TestBlobId;
import org.apache.james.blob.export.api.ExportedFileNamesGenerator;
import org.apache.james.blob.export.api.FileExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ExportedFileNamesGeneratorTest {
    private static final TestBlobId.Factory BLOB_ID_FACTORY = new TestBlobId.Factory();
    private static final BlobId BLOB_ID = BLOB_ID_FACTORY.from("blobId");

    ExportedFileNamesGeneratorTest() {
    }

    @Test
    void generateFileNameShouldNotHavePrefixWhenEmptyPrefix() {
        Optional prefix = Optional.empty();
        Optional<FileExtension> extension = Optional.of(FileExtension.ZIP);
        Assertions.assertThat((String)ExportedFileNamesGenerator.generateFileName(prefix, (BlobId)BLOB_ID, extension)).isEqualTo("blobId.zip");
    }

    @Test
    void generateFileNameShouldNotHaveSuffixWhenEmptySuffix() {
        Optional extension = Optional.empty();
        Assertions.assertThat((String)ExportedFileNamesGenerator.generateFileName(Optional.of("prefix-"), (BlobId)BLOB_ID, extension)).isEqualTo("prefix-blobId");
    }

    @Test
    void generateFileNameShouldNotHaveSuffixAndPrefixWhenNotSpecifying() {
        Optional prefix = Optional.empty();
        Optional extension = Optional.empty();
        Assertions.assertThat((String)ExportedFileNamesGenerator.generateFileName(prefix, (BlobId)BLOB_ID, extension)).isEqualTo("blobId");
    }

    @Test
    void generateFileNameShouldHaveSuffixAndPrefixWhenSpecified() {
        Optional<FileExtension> extension = Optional.of(FileExtension.ZIP);
        Assertions.assertThat((String)ExportedFileNamesGenerator.generateFileName(Optional.of("prefix-"), (BlobId)BLOB_ID, extension)).isEqualTo("prefix-blobId.zip");
    }

    @Test
    void generateFileNameShouldThrowWhenNullBlobId() {
        BlobId nullBlobId = null;
        Assertions.assertThatThrownBy(() -> ExportedFileNamesGenerator.generateFileName(Optional.empty(), (BlobId)nullBlobId, Optional.empty())).isInstanceOf(NullPointerException.class);
    }
}

