/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;

public class FakeMimeMessage
extends MimeMessage {
    private final List<Serializable> m_fromAddresses = new ArrayList<Serializable>();
    private Address m_senderAddress;
    private final List<Serializable> m_toRecepients = new ArrayList<Serializable>();
    private final List<Serializable> m_ccRecepients = new ArrayList<Serializable>();
    private final List<Serializable> m_bccRecepients = new ArrayList<Serializable>();
    private final List<Serializable> m_replyToAddresses = new ArrayList<Serializable>();
    private String m_subject;
    private int m_iMessageNumber;
    private boolean m_bIsExpunged;
    private Object m_content;
    private Date m_sentDate;
    private String[] m_contentLanguage;
    private String m_fileName;
    private DataHandler m_dataHandler;
    private HashMap<String, String> m_contentHeaders = new HashMap();
    private Flags m_setFlags = new Flags();
    private boolean m_doMatch;

    public FakeMimeMessage() throws MessagingException {
        super((Session)null);
    }

    public FakeMimeMessage(int messageNumber) throws MessagingException {
        super((Session)null);
        this.m_iMessageNumber = messageNumber;
    }

    public FakeMimeMessage(MimeMessage mimeMessage) throws MessagingException {
        super(mimeMessage);
    }

    public Address[] getFrom() throws MessagingException {
        return this.m_fromAddresses.toArray(new Address[this.m_fromAddresses.size()]);
    }

    public void setFrom(Address address) throws MessagingException {
        this.m_fromAddresses.clear();
        this.m_fromAddresses.add((Serializable)address);
    }

    public void setFrom() throws MessagingException {
        this.m_fromAddresses.clear();
        this.m_fromAddresses.add((Serializable)InternetAddress.getLocalAddress(null));
    }

    public void addFrom(Address[] addresses) throws MessagingException {
        this.m_fromAddresses.add((Serializable)addresses);
    }

    public Address getSender() throws MessagingException {
        return this.m_senderAddress;
    }

    public void setSender(Address address) throws MessagingException {
        this.m_senderAddress = address;
    }

    public Address[] getRecipients(Message.RecipientType recipientType) throws MessagingException {
        List<Serializable> recipientsList = this.getRecipientsList(recipientType);
        ArrayList<InternetAddress> recipientAddresses = new ArrayList<InternetAddress>();
        for (Serializable aRecipientsList : recipientsList) {
            String recipient = (String)((Object)aRecipientsList);
            recipientAddresses.add(new InternetAddress(recipient));
        }
        return recipientAddresses.toArray(new Address[recipientAddresses.size()]);
    }

    private List<Serializable> getRecipientsList(Message.RecipientType recipientType) {
        if (Message.RecipientType.TO.equals(recipientType)) {
            return this.m_toRecepients;
        }
        if (Message.RecipientType.CC.equals(recipientType)) {
            return this.m_ccRecepients;
        }
        if (Message.RecipientType.BCC.equals(recipientType)) {
            return this.m_bccRecepients;
        }
        return null;
    }

    public Address[] getAllRecipients() throws MessagingException {
        ArrayList<Serializable> allRecipients = new ArrayList<Serializable>();
        allRecipients.addAll(this.m_toRecepients);
        allRecipients.addAll(this.m_ccRecepients);
        allRecipients.addAll(this.m_bccRecepients);
        return (Address[])allRecipients.toArray();
    }

    public void setRecipients(Message.RecipientType recipientType, Address[] addresses) throws MessagingException {
        this.getRecipientsList(recipientType).addAll(Arrays.asList(addresses));
    }

    public void setRecipients(Message.RecipientType recipientType, String recipient) throws MessagingException {
        this.getRecipientsList(recipientType).add((Serializable)((Object)recipient));
    }

    public void addRecipients(Message.RecipientType recipientType, Address[] addresses) throws MessagingException {
        this.getRecipientsList(recipientType).addAll(Arrays.asList(addresses));
    }

    public void addRecipients(Message.RecipientType recipientType, String recipient) throws MessagingException {
        this.getRecipientsList(recipientType).add((Serializable)((Object)recipient));
    }

    public Address[] getReplyTo() throws MessagingException {
        return (Address[])this.m_replyToAddresses.toArray();
    }

    public void setReplyTo(Address[] addresses) throws MessagingException {
        this.m_replyToAddresses.addAll(Arrays.asList(addresses));
    }

    public String getSubject() throws MessagingException {
        return this.m_subject;
    }

    public void setSubject(String subject) throws MessagingException {
        this.m_subject = subject;
    }

    public void setSubject(String subject, String charset) throws MessagingException {
        if (subject == null) {
            this.m_subject = null;
            return;
        }
        try {
            this.m_subject = new String(subject.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("setting subject failed", (Exception)e);
        }
    }

    public Date getSentDate() throws MessagingException {
        return this.m_sentDate;
    }

    public void setSentDate(Date date) throws MessagingException {
        this.m_sentDate = date;
    }

    public Date getReceivedDate() throws MessagingException {
        return null;
    }

    public int getSize() throws MessagingException {
        return -1;
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public String getContentType() throws MessagingException {
        return this.getHeader("Content-Type", null);
    }

    public boolean isMimeType(String mimeType) throws MessagingException {
        return mimeType.startsWith(this.getContentType());
    }

    public String getDisposition() throws MessagingException {
        return this.getHeader("Content-Disposition", null);
    }

    public void setDisposition(String disposition) throws MessagingException {
        this.setHeader("Content-Disposition", disposition);
    }

    public String getEncoding() throws MessagingException {
        return this.getHeader("Content-Transfer-Encoding", null);
    }

    public String getContentID() throws MessagingException {
        return this.getHeader("Content-ID", null);
    }

    public void setContentID(String contentID) throws MessagingException {
        this.setHeader("Content-ID", contentID);
    }

    public String getContentMD5() throws MessagingException {
        return this.getHeader("Content-MD5", null);
    }

    public void setContentMD5(String value) throws MessagingException {
        this.setHeader("Content-MD5", value);
    }

    public String getDescription() throws MessagingException {
        return this.getHeader("Content-Description", null);
    }

    public void setDescription(String description) throws MessagingException {
        this.setHeader("Content-Description", description);
    }

    public void setDescription(String description, String charset) throws MessagingException {
        try {
            this.setDescription(new String(description.getBytes(charset)));
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("setting description failed", (Exception)e);
        }
    }

    public String[] getContentLanguage() throws MessagingException {
        return this.m_contentLanguage;
    }

    public void setContentLanguage(String[] contentLanguage) throws MessagingException {
        this.m_contentLanguage = contentLanguage;
    }

    public String getMessageID() throws MessagingException {
        return "ID-" + this.m_iMessageNumber;
    }

    public String getFileName() throws MessagingException {
        return this.m_fileName;
    }

    public void setFileName(String fileName) throws MessagingException {
        this.m_fileName = fileName;
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return null;
    }

    protected InputStream getContentStream() throws MessagingException {
        return null;
    }

    public InputStream getRawInputStream() throws MessagingException {
        if (this.m_content instanceof String) {
            return new ByteArrayInputStream(this.m_content.toString().getBytes());
        }
        throw new UnsupportedOperationException("Unimplementated method");
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        return this.m_dataHandler;
    }

    public synchronized void setDataHandler(DataHandler dataHandler) throws MessagingException {
        this.m_dataHandler = dataHandler;
    }

    public Object getContent() throws IOException, MessagingException {
        return this.m_content;
    }

    public void setContent(Object object, String mimeType) throws MessagingException {
        this.m_content = object;
        this.addHeader("Content-Type", mimeType);
    }

    public void setText(String string) throws MessagingException {
        this.setContent(string, "text/plain");
    }

    public void setText(String string, String charset) throws MessagingException {
        try {
            this.setContent(new String(string.getBytes(charset)), "text/plain");
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("setting text content failed", (Exception)e);
        }
    }

    public void setContent(Multipart multipart) throws MessagingException {
        this.m_content = multipart;
    }

    public Message reply(boolean b) throws MessagingException {
        return new FakeMimeMessage(this);
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
    }

    public void writeTo(OutputStream outputStream, String[] strings) throws IOException, MessagingException {
    }

    public String[] getHeader(String name) throws MessagingException {
        String value = this.m_contentHeaders.get(name);
        if (value == null) {
            return null;
        }
        return new String[]{value};
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        String[] header = this.getHeader(name);
        if (header == null || header.length == 0) {
            return null;
        }
        return header[0];
    }

    public void setHeader(String name, String value) throws MessagingException {
        this.addHeader(name, value);
    }

    public void addHeader(String name, String value) throws MessagingException {
        this.m_contentHeaders.put(name, value);
    }

    public void removeHeader(String name) throws MessagingException {
        this.m_contentHeaders.remove(name);
    }

    public Enumeration<String> getAllHeaders() throws MessagingException {
        return Collections.enumeration(this.m_contentHeaders.values());
    }

    public Enumeration<String> getMatchingHeaders(String[] names) throws MessagingException {
        ArrayList<String> matchingHeaders = new ArrayList<String>();
        for (String name : names) {
            String value = this.getHeader(name, null);
            if (value == null) continue;
            matchingHeaders.add(value);
        }
        return Collections.enumeration(matchingHeaders);
    }

    public Enumeration<String> getNonMatchingHeaders(String[] names) throws MessagingException {
        List<String> existingHeaders = Arrays.asList(names);
        ArrayList<String> nonMatchingHeaders = new ArrayList<String>();
        for (String name : this.m_contentHeaders.keySet()) {
            String value;
            if (existingHeaders.contains(name) || (value = this.getHeader(name, null)) == null) continue;
            nonMatchingHeaders.add(value);
        }
        return Collections.enumeration(nonMatchingHeaders);
    }

    public void addHeaderLine(String headerLine) throws MessagingException {
        int separatorIndex = headerLine.indexOf(":");
        if (separatorIndex < 0) {
            throw new MessagingException("header line does not conform to standard");
        }
        this.addHeader(headerLine.substring(0, separatorIndex), headerLine.substring(separatorIndex, headerLine.length()));
    }

    public Enumeration<String> getAllHeaderLines() throws MessagingException {
        return Collections.enumeration(this.getHeadersAsStrings(this.m_contentHeaders));
    }

    private ArrayList<String> getHeadersAsStrings(HashMap<String, String> contentHeaders) {
        ArrayList<String> headerLines = new ArrayList<String>();
        for (String key : contentHeaders.keySet()) {
            String value = contentHeaders.get(key);
            headerLines.add(key + ":" + value);
        }
        return headerLines;
    }

    public Enumeration<String> getMatchingHeaderLines(String[] names) throws MessagingException {
        ArrayList<String> matchingHeaders = new ArrayList<String>();
        for (String name : names) {
            String value = this.getHeader(name, null);
            if (value == null) continue;
            matchingHeaders.add(name + ":" + value);
        }
        return Collections.enumeration(matchingHeaders);
    }

    public Enumeration<String> getNonMatchingHeaderLines(String[] names) throws MessagingException {
        List<String> existingHeaders = names != null ? Arrays.asList(names) : null;
        ArrayList<String> nonMatchingHeaders = new ArrayList<String>();
        for (String name : this.m_contentHeaders.keySet()) {
            String value;
            if (existingHeaders != null && existingHeaders.contains(name) || (value = this.getHeader(name, null)) == null) continue;
            nonMatchingHeaders.add(name + ":" + value);
        }
        return Collections.enumeration(nonMatchingHeaders);
    }

    public synchronized Flags getFlags() throws MessagingException {
        return new Flags(this.m_setFlags);
    }

    public synchronized boolean isSet(Flags.Flag flag) throws MessagingException {
        return this.m_setFlags.contains(flag);
    }

    public synchronized void setFlags(Flags flags, boolean set) throws MessagingException {
        if (set) {
            this.m_setFlags.add(flags);
        } else {
            this.m_setFlags.remove(flags);
        }
    }

    public void saveChanges() throws MessagingException {
    }

    protected void updateHeaders() throws MessagingException {
    }

    protected InternetHeaders createInternetHeaders(InputStream inputStream) throws MessagingException {
        return new InternetHeaders();
    }

    public void setRecipient(Message.RecipientType recipientType, Address address) throws MessagingException {
        this.setRecipients(recipientType, new Address[]{address});
    }

    public void addRecipient(Message.RecipientType recipientType, Address address) throws MessagingException {
        this.setRecipients(recipientType, new Address[]{address});
    }

    public void setFlag(Flags.Flag flag, boolean set) throws MessagingException {
        if (set) {
            this.m_setFlags.add(flag);
        } else {
            this.m_setFlags.remove(flag);
        }
    }

    public int getMessageNumber() {
        return this.m_iMessageNumber;
    }

    protected void setMessageNumber(int i) {
        this.m_iMessageNumber = i;
    }

    public Folder getFolder() {
        return null;
    }

    public boolean isExpunged() {
        return this.m_bIsExpunged;
    }

    protected void setExpunged(boolean b) {
        this.m_bIsExpunged = b;
    }

    public void setShouldMatch(boolean doMatch) {
        this.m_doMatch = doMatch;
    }

    public boolean match(SearchTerm searchTerm) throws MessagingException {
        return this.m_doMatch;
    }
}

