/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import java.util.Arrays;
import java.util.Collection;
import javax.mail.MessagingException;
import junit.framework.TestCase;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.Matcher;
import org.apache.mailet.base.GenericMatcher;
import org.apache.mailet.base.MatcherInverter;
import org.apache.mailet.base.test.FakeMail;

public class MatcherInverterTest
extends TestCase {
    public void testAllMatch() throws MessagingException {
        MatcherInverter inverter = new MatcherInverter((Matcher)new GenericMatcher(){

            public Collection<MailAddress> match(Mail mail) throws MessagingException {
                return null;
            }
        });
        FakeMail mail = new FakeMail();
        mail.setRecipients(Arrays.asList(new MailAddress("user", "domain")));
        MatcherInverterTest.assertNotNull((String)"Should match all recipients", (Object)inverter.match((Mail)mail));
    }

    public void testNonMatch() throws MessagingException {
        MailAddress address1 = new MailAddress("user", "domain");
        MailAddress address2 = new MailAddress("user", "domain2");
        MatcherInverter inverter = new MatcherInverter((Matcher)new GenericMatcher(){

            public Collection<MailAddress> match(Mail mail) throws MessagingException {
                return mail.getRecipients();
            }
        });
        FakeMail mail = new FakeMail();
        mail.setRecipients(Arrays.asList(address1, address2));
        MatcherInverterTest.assertNull((String)"Should match all recipients", (Object)inverter.match((Mail)mail));
    }

    public void testOneMatch() throws MessagingException {
        final MailAddress address1 = new MailAddress("user", "domain");
        MailAddress address2 = new MailAddress("user", "domain2");
        MatcherInverter inverter = new MatcherInverter((Matcher)new GenericMatcher(){

            public Collection<MailAddress> match(Mail mail) throws MessagingException {
                return Arrays.asList(address1);
            }
        });
        FakeMail mail = new FakeMail();
        mail.setRecipients(Arrays.asList(address1, address2));
        MatcherInverterTest.assertEquals((String)"Should match one recipient", (String)address2.toString(), (String)((MailAddress)inverter.match((Mail)mail).iterator().next()).toString());
    }
}

