/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base.test;

import java.util.Arrays;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMimeMessage;

public class MailUtil {
    private static int m_counter = 0;

    public static String newId() {
        return "MockMailUtil-ID-" + ++m_counter;
    }

    public static FakeMail createMockMail2Recipients(MimeMessage m) throws ParseException {
        FakeMail mockedMail = new FakeMail();
        mockedMail.setName(MailUtil.newId());
        mockedMail.setMessage(m);
        mockedMail.setRecipients(Arrays.asList(new MailAddress("test@james.apache.org"), new MailAddress("test2@james.apache.org")));
        return mockedMail;
    }

    public static FakeMimeMessage createMimeMessage() throws MessagingException {
        return MailUtil.createMimeMessage(null, null);
    }

    public static FakeMimeMessage createMimeMessageWithSubject(String subject) throws MessagingException {
        return MailUtil.createMimeMessage(null, null, subject, 0);
    }

    public static FakeMimeMessage createMimeMessage(String subject, int number) throws MessagingException {
        return MailUtil.createMimeMessage(null, null, subject, number);
    }

    public static FakeMimeMessage createMimeMessage(String headerName, String headerValue) throws MessagingException {
        return MailUtil.createMimeMessage(headerName, headerValue, "testmail", 0);
    }

    public static FakeMimeMessage createMimeMessage(String headerName, String headerValue, String subject, int number) throws MessagingException {
        String sender = "test@james.apache.org";
        String rcpt = "test2@james.apache.org";
        FakeMimeMessage mockedMimeMessage = new FakeMimeMessage(number);
        mockedMimeMessage.setFrom((Address)new InternetAddress(sender));
        mockedMimeMessage.setRecipients(MimeMessage.RecipientType.TO, rcpt);
        if (headerName != null) {
            mockedMimeMessage.setHeader(headerName, headerValue);
        }
        if (subject != null) {
            mockedMimeMessage.setSubject(subject);
        }
        mockedMimeMessage.setText("testtext");
        mockedMimeMessage.saveChanges();
        return mockedMimeMessage;
    }
}

