/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import junit.framework.TestCase;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.MailetUtil;
import org.apache.mailet.base.test.FakeMailetConfig;

public class MailetUtilTest
extends TestCase {
    private static final String A_PARAMETER = "aParameter";
    FakeMailetConfig config;

    protected void setUp() throws Exception {
        super.setUp();
        this.config = new FakeMailetConfig();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetInitParameterParameterIsTrue() {
        MailetUtilTest.assertTrue((boolean)this.getParameterValued("true", true));
        MailetUtilTest.assertTrue((boolean)this.getParameterValued("true", false));
        MailetUtilTest.assertTrue((boolean)this.getParameterValued("TRUE", true));
        MailetUtilTest.assertTrue((boolean)this.getParameterValued("TRUE", false));
        MailetUtilTest.assertTrue((boolean)this.getParameterValued("trUE", true));
        MailetUtilTest.assertTrue((boolean)this.getParameterValued("trUE", false));
    }

    public void testGetInitParameterParameterIsFalse() {
        MailetUtilTest.assertFalse((boolean)this.getParameterValued("false", true));
        MailetUtilTest.assertFalse((boolean)this.getParameterValued("false", false));
        MailetUtilTest.assertFalse((boolean)this.getParameterValued("FALSE", true));
        MailetUtilTest.assertFalse((boolean)this.getParameterValued("FALSE", false));
        MailetUtilTest.assertFalse((boolean)this.getParameterValued("fALSe", true));
        MailetUtilTest.assertFalse((boolean)this.getParameterValued("fALSe", false));
    }

    public void testGetInitParameterParameterDefaultsToTrue() {
        MailetUtilTest.assertTrue((boolean)this.getParameterValued("fals", true));
        MailetUtilTest.assertTrue((boolean)this.getParameterValued("TRU", true));
        MailetUtilTest.assertTrue((boolean)this.getParameterValued("FALSEest", true));
        MailetUtilTest.assertTrue((boolean)this.getParameterValued("", true));
        MailetUtilTest.assertTrue((boolean)this.getParameterValued("gubbins", true));
    }

    public void testGetInitParameterParameterDefaultsToFalse() {
        MailetUtilTest.assertFalse((boolean)this.getParameterValued("fals", false));
        MailetUtilTest.assertFalse((boolean)this.getParameterValued("TRU", false));
        MailetUtilTest.assertFalse((boolean)this.getParameterValued("FALSEest", false));
        MailetUtilTest.assertFalse((boolean)this.getParameterValued("", false));
        MailetUtilTest.assertFalse((boolean)this.getParameterValued("gubbins", false));
    }

    private boolean getParameterValued(String value, boolean defaultValue) {
        this.config.clear();
        this.config.setProperty(A_PARAMETER, value);
        return MailetUtil.getInitParameter((MailetConfig)this.config, (String)A_PARAMETER, (boolean)defaultValue);
    }
}

