/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.smtp.host;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.inject.Module;
import java.util.Iterator;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.GuiceJamesServer;
import org.apache.james.backends.cassandra.EmbeddedCassandra;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.mailbox.elasticsearch.EmbeddedElasticSearch;
import org.apache.james.modules.CassandraJmapServerModule;
import org.apache.james.mpt.api.Monitor;
import org.apache.james.mpt.monitor.SystemLoggingMonitor;
import org.apache.james.mpt.session.ExternalSessionFactory;
import org.apache.james.mpt.smtp.SmtpHostSystem;
import org.apache.james.mpt.smtp.dns.InMemoryDNSService;
import org.junit.rules.TemporaryFolder;

public class CassandraJamesSmtpHostSystem
extends ExternalSessionFactory
implements SmtpHostSystem {
    private TemporaryFolder folder;
    private EmbeddedCassandra embeddedCassandra;
    private EmbeddedElasticSearch embeddedElasticSearch;
    private GuiceJamesServer jamesServer;
    private InMemoryDNSService inMemoryDNSService;

    public CassandraJamesSmtpHostSystem() {
        super("localhost", 1025, (Monitor)new SystemLoggingMonitor(), "220 mydomain.tld smtp");
    }

    public boolean addUser(String userAtDomain, String password) throws Exception {
        Preconditions.checkArgument((boolean)userAtDomain.contains("@"), (Object)"The 'user' should contain the 'domain'");
        Iterator split = Splitter.on((String)"@").split((CharSequence)userAtDomain).iterator();
        split.next();
        String domain = (String)split.next();
        this.createDomainIfNeeded(domain);
        this.jamesServer.serverProbe().addUser(userAtDomain, password);
        return true;
    }

    private void createDomainIfNeeded(String domain) throws Exception {
        if (!this.jamesServer.serverProbe().containsDomain(domain)) {
            this.jamesServer.serverProbe().addDomain(domain);
        }
    }

    public void addAddressMapping(String user, String domain, String address) throws Exception {
        this.jamesServer.serverProbe().addAddressMapping(user, domain, address);
    }

    public void beforeTests() throws Exception {
    }

    public void afterTests() throws Exception {
    }

    public void beforeTest() throws Exception {
        this.inMemoryDNSService = new InMemoryDNSService();
        this.folder = new TemporaryFolder();
        this.folder.create();
        this.embeddedElasticSearch = new EmbeddedElasticSearch(this.folder.getRoot().toPath());
        this.embeddedElasticSearch.before();
        this.embeddedCassandra = EmbeddedCassandra.createStartServer();
        this.jamesServer = this.createJamesServer();
        this.jamesServer.start();
    }

    public void afterTest() throws Exception {
        this.jamesServer.stop();
        this.embeddedElasticSearch.after();
        this.folder.delete();
    }

    public InMemoryDNSService getInMemoryDnsService() {
        return this.inMemoryDNSService;
    }

    protected GuiceJamesServer createJamesServer() {
        Module[] moduleArray = new Module[2];
        moduleArray[0] = new CassandraJmapServerModule(() -> ((TemporaryFolder)this.folder).getRoot(), this.embeddedElasticSearch, this.embeddedCassandra);
        moduleArray[1] = binder -> binder.bind(DNSService.class).toInstance((Object)this.inMemoryDNSService);
        return new GuiceJamesServer().combineWith(new Module[]{CassandraJamesServerMain.cassandraServerModule}).overrideWith(moduleArray);
    }
}

