/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.onami.test.guice;

import javax.inject.Inject;
import org.apache.james.mpt.onami.test.OnamiRunner;
import org.apache.james.mpt.onami.test.annotation.GuiceModules;
import org.apache.james.mpt.onami.test.annotation.Mock;
import org.apache.james.mpt.onami.test.data.HelloWorld;
import org.apache.james.mpt.onami.test.data.Service;
import org.apache.james.mpt.onami.test.data.ServiceModule;
import org.apache.james.mpt.onami.test.data.TelephonService;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=OnamiRunner.class)
@GuiceModules(value={ServiceModule.class})
public class TestCustomInjectionTest {
    @Mock
    private static Service service;
    @Inject
    private TelephonService telephonService;
    @Inject
    private HelloWorld helloWorld;

    @BeforeClass
    public static void setUp() {
        Assert.assertNotNull((Object)service);
    }

    @Test
    public void test() throws Exception {
        Assert.assertNotNull((Object)service);
        Assert.assertNotNull((Object)this.telephonService);
        Assert.assertNotNull((Object)this.helloWorld);
    }

    @Test
    public void testOverideModule() throws Exception {
        Assert.assertNotNull((Object)service);
        Assert.assertNotNull((Object)this.telephonService);
        Assert.assertEquals((Object)"It's real class", (Object)this.telephonService.getTelephonNumber());
        EasyMock.expect((Object)service.go()).andReturn((Object)"Mocked injected class");
        EasyMock.replay((Object[])new Object[]{service});
        Assert.assertEquals((Object)"Mocked injected class", (Object)this.helloWorld.sayHalloByService());
        EasyMock.verify((Object[])new Object[]{service});
    }
}

