/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.onami.test;

import com.google.inject.Injector;
import javax.inject.Inject;
import org.apache.james.mpt.onami.test.AbstractMockTestCase;
import org.apache.james.mpt.onami.test.OnamiRunner;
import org.apache.james.mpt.onami.test.annotation.GuiceModules;
import org.apache.james.mpt.onami.test.annotation.Mock;
import org.apache.james.mpt.onami.test.data.HelloWorld;
import org.apache.james.mpt.onami.test.data.SimpleModule;
import org.apache.james.mpt.onami.test.data.TelephonService;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=OnamiRunner.class)
@GuiceModules(value={SimpleModule.class})
public class InjectMockObjectTestCase
extends AbstractMockTestCase {
    @Mock
    private TelephonService telephonServiceMock;
    @Inject
    Injector injector;
    @Inject
    private HelloWorld helloWorld;

    @Test
    public void testMock() {
        EasyMock.expect((Object)this.providedMock.go()).andReturn((Object)"Ciao");
        EasyMock.replay((Object[])new Object[]{this.providedMock});
        Assert.assertNotNull((Object)this.providedMock);
        Assert.assertEquals((Object)"Ciao", (Object)this.helloWorld.sayHalloByService());
        EasyMock.verify((Object[])new Object[]{this.providedMock});
    }

    @Test
    public void testMock2() {
        EasyMock.expect((Object)this.providedMock.go()).andReturn((Object)"Ciao");
        EasyMock.replay((Object[])new Object[]{this.providedMock});
        Assert.assertNotNull((Object)this.providedMock);
        Assert.assertEquals((Object)"Ciao", (Object)this.helloWorld.sayHalloByService());
        EasyMock.verify((Object[])new Object[]{this.providedMock});
    }

    @Test
    public void testStrickMock() {
        EasyMock.expect((Object)this.telephonServiceMock.getTelephonNumber()).andReturn((Object)"1234567890");
        this.providedMock.call("1234567890");
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.telephonServiceMock});
        EasyMock.replay((Object[])new Object[]{this.providedMock});
        this.helloWorld.callHelloWorldTelephon();
        EasyMock.verify((Object[])new Object[]{this.telephonServiceMock});
        EasyMock.verify((Object[])new Object[]{this.providedMock});
        EasyMock.reset((Object[])new Object[]{this.telephonServiceMock});
    }

    @Test
    public void testStrickMock2() {
        Assert.assertNotNull((Object)this.telephonServiceMock);
    }
}

