/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.onami.test;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.mpt.onami.test.OnamiRunner;
import org.apache.james.mpt.onami.test.annotation.Mock;
import org.apache.james.mpt.onami.test.data.HelloWorld;
import org.apache.james.mpt.onami.test.data.Service;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=OnamiRunner.class)
public class InjectDependingMockObjectTestCase {
    @Mock
    private static Service service;
    @Inject
    Injector injector;
    private HelloWorld helloWorld;

    @Before
    public void setUp() {
        final ArrayList<Service> list = new ArrayList<Service>();
        list.add(service);
        AbstractModule listAbstractModule = new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<List<Service>>(){}).toInstance((Object)list);
            }
        };
        Injector cInjector = this.injector.createChildInjector(new Module[]{listAbstractModule});
        this.helloWorld = (HelloWorld)cInjector.getInstance(HelloWorld.class);
        cInjector.injectMembers((Object)this.helloWorld);
    }

    @Test
    public void testMock() {
        Assert.assertNotNull((Object)this.helloWorld);
        Assert.assertNotNull((Object)service);
        EasyMock.expect((Object)service.go()).andReturn((Object)"Ciao");
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{service});
        this.helloWorld.sayHalloByServiceLists();
        EasyMock.verify((Object[])new Object[]{service});
    }
}

