/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.maildir.host;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.InVMEventBus;
import org.apache.james.events.MemoryEventDeadLetters;
import org.apache.james.events.delivery.EventDelivery;
import org.apache.james.events.delivery.InVmEventDelivery;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.encode.main.DefaultImapEncoderFactory;
import org.apache.james.imap.main.DefaultImapDecoderFactory;
import org.apache.james.imap.processor.main.DefaultImapProcessorFactory;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.maildir.MaildirMailboxSessionMapperFactory;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxManagerConfiguration;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.SessionProviderImpl;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.StoreSubscriptionManager;
import org.apache.james.mailbox.store.extractor.DefaultTextExtractor;
import org.apache.james.mailbox.store.mail.MailboxMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.search.SimpleMessageSearchIndex;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.logger.DefaultMetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.host.JamesImapHostSystem;

public class MaildirHostSystem
extends JamesImapHostSystem {
    private static final String META_DATA_DIRECTORY = "target/user-meta-data";
    private static final String MAILDIR_HOME = "target/Maildir";
    private static final ImapFeatures SUPPORTED_FEATURES = ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[0]);
    private StoreMailboxManager mailboxManager;

    public void beforeTest() throws Exception {
        super.beforeTest();
        JVMMailboxPathLocker locker = new JVMMailboxPathLocker();
        MaildirStore store = new MaildirStore("target/Maildir/%user", (MailboxPathLocker)locker);
        MaildirMailboxSessionMapperFactory mailboxSessionMapperFactory = new MaildirMailboxSessionMapperFactory(store);
        StoreSubscriptionManager sm = new StoreSubscriptionManager((SubscriptionMapperFactory)mailboxSessionMapperFactory);
        UnionMailboxACLResolver aclResolver = new UnionMailboxACLResolver();
        SimpleGroupMembershipResolver groupMembershipResolver = new SimpleGroupMembershipResolver();
        MessageParser messageParser = new MessageParser();
        InVMEventBus eventBus = new InVMEventBus((EventDelivery)new InVmEventDelivery((MetricFactory)new RecordingMetricFactory()), EventBusTestFixture.RETRY_BACKOFF_CONFIGURATION, (EventDeadLetters)new MemoryEventDeadLetters());
        StoreRightManager storeRightManager = new StoreRightManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, (MailboxACLResolver)aclResolver, (GroupMembershipResolver)groupMembershipResolver, (EventBus)eventBus);
        StoreMailboxAnnotationManager annotationManager = new StoreMailboxAnnotationManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, storeRightManager);
        SessionProviderImpl sessionProvider = new SessionProviderImpl(this.authenticator, this.authorizator);
        QuotaComponents quotaComponents = QuotaComponents.disabled((SessionProvider)sessionProvider, (MailboxSessionMapperFactory)mailboxSessionMapperFactory);
        SimpleMessageSearchIndex index = new SimpleMessageSearchIndex((MessageMapperFactory)mailboxSessionMapperFactory, (MailboxMapperFactory)mailboxSessionMapperFactory, (TextExtractor)new DefaultTextExtractor(), null);
        this.mailboxManager = new StoreMailboxManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, (SessionProvider)sessionProvider, (MailboxPathLocker)locker, messageParser, (MessageId.Factory)new DefaultMessageId.Factory(), (MailboxAnnotationManager)annotationManager, (EventBus)eventBus, storeRightManager, quotaComponents, (MessageSearchIndex)index, MailboxManagerConfiguration.DEFAULT, PreDeletionHooks.NO_PRE_DELETION_HOOK);
        ImapProcessor defaultImapProcessorFactory = DefaultImapProcessorFactory.createDefaultProcessor((MailboxManager)this.mailboxManager, (EventBus)eventBus, (SubscriptionManager)sm, (QuotaManager)quotaComponents.getQuotaManager(), (QuotaRootResolver)quotaComponents.getQuotaRootResolver(), (MetricFactory)new DefaultMetricFactory());
        this.configure(new DefaultImapDecoderFactory().buildImapDecoder(), new DefaultImapEncoderFactory().buildImapEncoder(), defaultImapProcessorFactory);
        new File(MAILDIR_HOME).mkdirs();
    }

    public void afterTest() throws Exception {
        this.resetUserMetaData();
        try {
            FileUtils.deleteDirectory((File)new File(MAILDIR_HOME));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetUserMetaData() throws Exception {
        File dir = new File(META_DATA_DIRECTORY);
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdirs();
    }

    protected MailboxManager getMailboxManager() {
        return this.mailboxManager;
    }

    public boolean supports(ImapFeatures.Feature ... features) {
        return SUPPORTED_FEATURES.supports(features);
    }

    public void setQuotaLimits(QuotaCountLimit maxMessageQuota, QuotaSizeLimit maxStorageQuota) {
        throw new NotImplementedException("not implemented");
    }

    protected void await() {
    }
}

