/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.maildir.host;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.encode.main.DefaultImapEncoderFactory;
import org.apache.james.imap.main.DefaultImapDecoderFactory;
import org.apache.james.imap.processor.main.DefaultImapProcessorFactory;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.maildir.MaildirMailboxSessionMapperFactory;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.StoreSubscriptionManager;
import org.apache.james.mailbox.store.event.DefaultDelegatingMailboxListener;
import org.apache.james.mailbox.store.event.DelegatingMailboxListener;
import org.apache.james.mailbox.store.event.MailboxEventDispatcher;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.DefaultUserQuotaRootResolver;
import org.apache.james.mailbox.store.quota.NoQuotaManager;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.logger.DefaultMetricFactory;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.host.JamesImapHostSystem;

public class MaildirHostSystem
extends JamesImapHostSystem {
    public static final String META_DATA_DIRECTORY = "target/user-meta-data";
    private static final String MAILDIR_HOME = "target/Maildir";
    private static final ImapFeatures SUPPORTED_FEATURES = ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[0]);
    private StoreMailboxManager mailboxManager;

    public static JamesImapHostSystem build() throws Exception {
        return new MaildirHostSystem();
    }

    public void beforeTest() throws Exception {
        super.beforeTest();
        JVMMailboxPathLocker locker = new JVMMailboxPathLocker();
        MaildirStore store = new MaildirStore("target/Maildir/%user", (MailboxPathLocker)locker);
        MaildirMailboxSessionMapperFactory mailboxSessionMapperFactory = new MaildirMailboxSessionMapperFactory(store);
        StoreSubscriptionManager sm = new StoreSubscriptionManager((SubscriptionMapperFactory)mailboxSessionMapperFactory);
        UnionMailboxACLResolver aclResolver = new UnionMailboxACLResolver();
        SimpleGroupMembershipResolver groupMembershipResolver = new SimpleGroupMembershipResolver();
        MessageParser messageParser = new MessageParser();
        DefaultDelegatingMailboxListener delegatingListener = new DefaultDelegatingMailboxListener();
        MailboxEventDispatcher mailboxEventDispatcher = new MailboxEventDispatcher((DelegatingMailboxListener)delegatingListener);
        StoreRightManager storeRightManager = new StoreRightManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, (MailboxACLResolver)aclResolver, (GroupMembershipResolver)groupMembershipResolver, mailboxEventDispatcher);
        StoreMailboxAnnotationManager annotationManager = new StoreMailboxAnnotationManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, storeRightManager);
        this.mailboxManager = new StoreMailboxManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, this.authenticator, this.authorizator, (MailboxPathLocker)locker, messageParser, (MessageId.Factory)new DefaultMessageId.Factory(), (MailboxAnnotationManager)annotationManager, mailboxEventDispatcher, (DelegatingMailboxListener)delegatingListener, storeRightManager);
        this.mailboxManager.init();
        ImapProcessor defaultImapProcessorFactory = DefaultImapProcessorFactory.createDefaultProcessor((MailboxManager)this.mailboxManager, (SubscriptionManager)sm, (QuotaManager)new NoQuotaManager(), (QuotaRootResolver)new DefaultUserQuotaRootResolver((MailboxSessionMapperFactory)mailboxSessionMapperFactory), (MetricFactory)new DefaultMetricFactory());
        this.configure(new DefaultImapDecoderFactory().buildImapDecoder(), new DefaultImapEncoderFactory().buildImapEncoder(), defaultImapProcessorFactory);
        new File(MAILDIR_HOME).mkdirs();
    }

    public void afterTest() throws Exception {
        this.resetUserMetaData();
        try {
            FileUtils.deleteDirectory((File)new File(MAILDIR_HOME));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetUserMetaData() throws Exception {
        File dir = new File(META_DATA_DIRECTORY);
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdirs();
    }

    protected MailboxManager getMailboxManager() {
        return this.mailboxManager;
    }

    public boolean supports(ImapFeatures.Feature ... features) {
        return SUPPORTED_FEATURES.supports(features);
    }

    public void setQuotaLimits(QuotaCount maxMessageQuota, QuotaSize maxStorageQuota) throws Exception {
        throw new NotImplementedException();
    }
}

