/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.maildir.host;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.encode.main.DefaultImapEncoderFactory;
import org.apache.james.imap.main.DefaultImapDecoderFactory;
import org.apache.james.imap.processor.main.DefaultImapProcessorFactory;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.maildir.MaildirMailboxSessionMapperFactory;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.FakeAuthenticator;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreSubscriptionManager;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.DefaultQuotaRootResolver;
import org.apache.james.mailbox.store.quota.NoQuotaManager;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.host.JamesImapHostSystem;
import org.apache.james.mpt.imapmailbox.MailboxCreationDelegate;

public class MaildirHostSystem
extends JamesImapHostSystem {
    public static final String META_DATA_DIRECTORY = "target/user-meta-data";
    private static final String MAILDIR_HOME = "target/Maildir";
    private static final ImapFeatures SUPPORTED_FEATURES = ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[0]);
    private final StoreMailboxManager mailboxManager;
    private final FakeAuthenticator userManager = new FakeAuthenticator();
    private final MaildirMailboxSessionMapperFactory mailboxSessionMapperFactory;

    public static JamesImapHostSystem build() throws Exception {
        return new MaildirHostSystem();
    }

    public MaildirHostSystem() throws MailboxException {
        JVMMailboxPathLocker locker = new JVMMailboxPathLocker();
        MaildirStore store = new MaildirStore("target/Maildir/%user", (MailboxPathLocker)locker);
        this.mailboxSessionMapperFactory = new MaildirMailboxSessionMapperFactory(store);
        StoreSubscriptionManager sm = new StoreSubscriptionManager((SubscriptionMapperFactory)this.mailboxSessionMapperFactory);
        UnionMailboxACLResolver aclResolver = new UnionMailboxACLResolver();
        SimpleGroupMembershipResolver groupMembershipResolver = new SimpleGroupMembershipResolver();
        MessageParser messageParser = new MessageParser();
        this.mailboxManager = new StoreMailboxManager((MailboxSessionMapperFactory)this.mailboxSessionMapperFactory, (Authenticator)this.userManager, (MailboxPathLocker)locker, (MailboxACLResolver)aclResolver, (GroupMembershipResolver)groupMembershipResolver, messageParser, (MessageId.Factory)new DefaultMessageId.Factory());
        this.mailboxManager.init();
        ImapProcessor defaultImapProcessorFactory = DefaultImapProcessorFactory.createDefaultProcessor((MailboxManager)this.mailboxManager, (SubscriptionManager)sm, (QuotaManager)new NoQuotaManager(), (QuotaRootResolver)new DefaultQuotaRootResolver((MailboxSessionMapperFactory)this.mailboxSessionMapperFactory));
        this.configure(new DefaultImapDecoderFactory().buildImapDecoder(), new DefaultImapEncoderFactory().buildImapEncoder(), defaultImapProcessorFactory);
        new File(MAILDIR_HOME).mkdirs();
    }

    public boolean addUser(String user, String password) throws Exception {
        this.userManager.addUser(user, password);
        return true;
    }

    public void resetData() throws Exception {
        this.resetUserMetaData();
        try {
            FileUtils.deleteDirectory((File)new File(MAILDIR_HOME));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetUserMetaData() throws Exception {
        File dir = new File(META_DATA_DIRECTORY);
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdirs();
    }

    public void createMailbox(MailboxPath mailboxPath) throws Exception {
        new MailboxCreationDelegate((MailboxManager)this.mailboxManager).createMailbox(mailboxPath);
    }

    public boolean supports(ImapFeatures.Feature ... features) {
        return SUPPORTED_FEATURES.supports(features);
    }
}

