/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.lucenesearch.host;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.encode.main.DefaultImapEncoderFactory;
import org.apache.james.imap.main.DefaultImapDecoderFactory;
import org.apache.james.imap.processor.main.DefaultImapProcessorFactory;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.events.EventBus;
import org.apache.james.mailbox.events.InVMEventBus;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.events.delivery.EventDelivery;
import org.apache.james.mailbox.events.delivery.InVmEventDelivery;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.inmemory.InMemoryMailboxManager;
import org.apache.james.mailbox.inmemory.InMemoryMailboxSessionMapperFactory;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.lucene.search.LuceneMessageSearchIndex;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.SessionProvider;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.StoreSubscriptionManager;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.DefaultUserQuotaRootResolver;
import org.apache.james.mailbox.store.quota.NoQuotaManager;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.NoopMetricFactory;
import org.apache.james.metrics.logger.DefaultMetricFactory;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.host.JamesImapHostSystem;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class LuceneSearchHostSystem
extends JamesImapHostSystem {
    public static final String META_DATA_DIRECTORY = "target/user-meta-data";
    private static final ImapFeatures SUPPORTED_FEATURES = ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT, ImapFeatures.Feature.MOD_SEQ_SEARCH});
    private File tempFile;
    private InMemoryMailboxManager mailboxManager;
    private LuceneMessageSearchIndex searchIndex;

    public void beforeTest() throws Exception {
        super.beforeTest();
        this.tempFile = Files.createTempDir();
        this.initFields();
    }

    public void afterTest() throws Exception {
        this.tempFile.deleteOnExit();
        this.resetUserMetaData();
        MailboxSession session = this.mailboxManager.createSystemSession("test");
        this.mailboxManager.startProcessingRequest(session);
        this.mailboxManager.endProcessingRequest(session);
        this.mailboxManager.logout(session, false);
    }

    public void resetUserMetaData() throws Exception {
        File dir = new File(META_DATA_DIRECTORY);
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdirs();
    }

    private void initFields() {
        try {
            InVMEventBus eventBus = new InVMEventBus((EventDelivery)new InVmEventDelivery((MetricFactory)new NoopMetricFactory()));
            InMemoryMailboxSessionMapperFactory mapperFactory = new InMemoryMailboxSessionMapperFactory();
            StoreRightManager rightManager = new StoreRightManager((MailboxSessionMapperFactory)mapperFactory, (MailboxACLResolver)new UnionMailboxACLResolver(), (GroupMembershipResolver)new SimpleGroupMembershipResolver(), (EventBus)eventBus);
            JVMMailboxPathLocker locker = new JVMMailboxPathLocker();
            InMemoryMessageId.Factory messageIdFactory = new InMemoryMessageId.Factory();
            SessionProvider sessionProvider = new SessionProvider(this.authenticator, this.authorizator);
            FSDirectory fsDirectory = FSDirectory.open((File)this.tempFile);
            this.searchIndex = new LuceneMessageSearchIndex((MailboxSessionMapperFactory)mapperFactory, (MailboxId.Factory)new InMemoryId.Factory(), (Directory)fsDirectory, (MessageId.Factory)messageIdFactory, sessionProvider);
            this.mailboxManager = new InMemoryMailboxManager((MailboxSessionMapperFactory)mapperFactory, sessionProvider, (MailboxPathLocker)locker, new MessageParser(), (MessageId.Factory)messageIdFactory, (EventBus)eventBus, new StoreMailboxAnnotationManager((MailboxSessionMapperFactory)mapperFactory, rightManager), rightManager, QuotaComponents.disabled((SessionProvider)sessionProvider, (MailboxSessionMapperFactory)mapperFactory), (MessageSearchIndex)this.searchIndex);
            this.searchIndex.setEnableSuffixMatch(true);
            eventBus.register((MailboxListener.GroupMailboxListener)this.searchIndex);
            StoreSubscriptionManager subscriptionManager = new StoreSubscriptionManager((SubscriptionMapperFactory)mapperFactory);
            ImapProcessor defaultImapProcessorFactory = DefaultImapProcessorFactory.createDefaultProcessor((MailboxManager)this.mailboxManager, (EventBus)eventBus, (SubscriptionManager)subscriptionManager, (QuotaManager)new NoQuotaManager(), (QuotaRootResolver)new DefaultUserQuotaRootResolver(sessionProvider, (MailboxSessionMapperFactory)mapperFactory), (MetricFactory)new DefaultMetricFactory());
            this.configure(new DefaultImapDecoderFactory().buildImapDecoder(), new DefaultImapEncoderFactory().buildImapEncoder(), defaultImapProcessorFactory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected MailboxManager getMailboxManager() {
        return this.mailboxManager;
    }

    public boolean supports(ImapFeatures.Feature ... features) {
        return SUPPORTED_FEATURES.supports(features);
    }

    public void setQuotaLimits(QuotaCount maxMessageQuota, QuotaSize maxStorageQuota) throws Exception {
        throw new NotImplementedException();
    }

    protected void await() throws Exception {
        this.searchIndex.commit();
    }
}

