/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.jcr.host;

import java.io.File;
import javax.jcr.Repository;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.encode.main.DefaultImapEncoderFactory;
import org.apache.james.imap.main.DefaultImapDecoderFactory;
import org.apache.james.imap.processor.main.DefaultImapProcessorFactory;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.jcr.GlobalMailboxSessionJCRRepository;
import org.apache.james.mailbox.jcr.JCRMailboxManager;
import org.apache.james.mailbox.jcr.JCRMailboxSessionMapperFactory;
import org.apache.james.mailbox.jcr.JCRSubscriptionManager;
import org.apache.james.mailbox.jcr.JCRUtils;
import org.apache.james.mailbox.jcr.MailboxSessionJCRRepository;
import org.apache.james.mailbox.jcr.mail.JCRModSeqProvider;
import org.apache.james.mailbox.jcr.mail.JCRUidProvider;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.FakeAuthenticator;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.DefaultQuotaRootResolver;
import org.apache.james.mailbox.store.quota.NoQuotaManager;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.host.JamesImapHostSystem;
import org.apache.james.mpt.imapmailbox.MailboxCreationDelegate;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class JCRHostSystem
extends JamesImapHostSystem {
    private final JCRMailboxManager mailboxManager;
    private final FakeAuthenticator userManager;
    private static final String JACKRABBIT_HOME = "target/jackrabbit";
    public static final String META_DATA_DIRECTORY = "target/user-meta-data";
    private static final ImapFeatures SUPPORTED_FEATURES = ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT});
    private RepositoryImpl repository;

    public static JamesImapHostSystem build() throws Exception {
        return new JCRHostSystem();
    }

    public JCRHostSystem() throws Exception {
        this.delete(new File(JACKRABBIT_HOME));
        try {
            String user = "user";
            String pass = "pass";
            String workspace = null;
            RepositoryConfig config = RepositoryConfig.create((InputSource)new InputSource(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-repository.xml")), (String)JACKRABBIT_HOME);
            this.repository = RepositoryImpl.create((RepositoryConfig)config);
            GlobalMailboxSessionJCRRepository sessionRepos = new GlobalMailboxSessionJCRRepository((Repository)this.repository, workspace, user, pass);
            JCRUtils.registerCnd((Repository)this.repository, workspace, (String)user, (String)pass);
            this.userManager = new FakeAuthenticator();
            JVMMailboxPathLocker locker = new JVMMailboxPathLocker();
            JCRUidProvider uidProvider = new JCRUidProvider((MailboxPathLocker)locker, (MailboxSessionJCRRepository)sessionRepos);
            JCRModSeqProvider modSeqProvider = new JCRModSeqProvider((MailboxPathLocker)locker, (MailboxSessionJCRRepository)sessionRepos);
            JCRMailboxSessionMapperFactory mf = new JCRMailboxSessionMapperFactory((MailboxSessionJCRRepository)sessionRepos, (UidProvider)uidProvider, (ModSeqProvider)modSeqProvider);
            UnionMailboxACLResolver aclResolver = new UnionMailboxACLResolver();
            SimpleGroupMembershipResolver groupMembershipResolver = new SimpleGroupMembershipResolver();
            MessageParser messageParser = new MessageParser();
            this.mailboxManager = new JCRMailboxManager(mf, (Authenticator)this.userManager, (MailboxPathLocker)locker, (MailboxACLResolver)aclResolver, (GroupMembershipResolver)groupMembershipResolver, messageParser, (MessageId.Factory)new DefaultMessageId.Factory());
            this.mailboxManager.init();
            ImapProcessor defaultImapProcessorFactory = DefaultImapProcessorFactory.createDefaultProcessor((MailboxManager)this.mailboxManager, (SubscriptionManager)new JCRSubscriptionManager(mf), (QuotaManager)new NoQuotaManager(), (QuotaRootResolver)new DefaultQuotaRootResolver((MailboxSessionMapperFactory)mf));
            this.resetUserMetaData();
            MailboxSession session = this.mailboxManager.createSystemSession("test", LoggerFactory.getLogger((String)"TestLog"));
            this.mailboxManager.startProcessingRequest(session);
            this.mailboxManager.endProcessingRequest(session);
            this.mailboxManager.logout(session, false);
            this.configure(new DefaultImapDecoderFactory().buildImapDecoder(), new DefaultImapEncoderFactory().buildImapEncoder(), defaultImapProcessorFactory);
        }
        catch (Exception e) {
            this.shutdownRepository();
            throw e;
        }
    }

    public boolean addUser(String user, String password) {
        this.userManager.addUser(user, password);
        return true;
    }

    public void resetData() throws Exception {
        this.resetUserMetaData();
    }

    public void resetUserMetaData() throws Exception {
        File dir = new File(META_DATA_DIRECTORY);
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdirs();
    }

    public void afterTests() throws Exception {
        this.shutdownRepository();
    }

    private void shutdownRepository() throws Exception {
        if (this.repository != null) {
            this.repository.shutdown();
            this.repository = null;
        }
    }

    private void delete(File home) throws Exception {
        if (home.exists()) {
            File[] files = home.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                if (f.isDirectory()) {
                    this.delete(f);
                    continue;
                }
                f.delete();
            }
            home.delete();
        }
    }

    public void createMailbox(MailboxPath mailboxPath) throws Exception {
        new MailboxCreationDelegate((MailboxManager)this.mailboxManager).createMailbox(mailboxPath);
    }

    public boolean supports(ImapFeatures.Feature ... features) {
        return SUPPORTED_FEATURES.supports(features);
    }
}

