/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.elasticsearch.host;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.james.backends.es.ElasticSearchIndexer;
import org.apache.james.backends.es.EmbeddedElasticSearch;
import org.apache.james.backends.es.utils.TestingClientProvider;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.encode.main.DefaultImapEncoderFactory;
import org.apache.james.imap.main.DefaultImapDecoderFactory;
import org.apache.james.imap.processor.main.DefaultImapProcessorFactory;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.elasticsearch.IndexAttachments;
import org.apache.james.mailbox.elasticsearch.MailboxElasticSearchConstants;
import org.apache.james.mailbox.elasticsearch.MailboxIndexCreationUtil;
import org.apache.james.mailbox.elasticsearch.events.ElasticSearchListeningMessageSearchIndex;
import org.apache.james.mailbox.elasticsearch.json.MessageToElasticSearchJson;
import org.apache.james.mailbox.elasticsearch.query.CriterionConverter;
import org.apache.james.mailbox.elasticsearch.query.QueryConverter;
import org.apache.james.mailbox.elasticsearch.search.ElasticSearchSearcher;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.inmemory.InMemoryMailboxSessionMapperFactory;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.mock.MockMailboxSession;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreSubscriptionManager;
import org.apache.james.mailbox.store.extractor.DefaultTextExtractor;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.quota.DefaultUserQuotaRootResolver;
import org.apache.james.mailbox.store.quota.NoQuotaManager;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.logger.DefaultMetricFactory;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.host.JamesImapHostSystem;
import org.elasticsearch.client.Client;

public class ElasticSearchHostSystem
extends JamesImapHostSystem {
    private static final ImapFeatures SUPPORTED_FEATURES = ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT, ImapFeatures.Feature.MOD_SEQ_SEARCH});
    private EmbeddedElasticSearch embeddedElasticSearch;
    private Path tempDirectory;
    private StoreMailboxManager mailboxManager;

    public void beforeTest() throws Exception {
        super.beforeTest();
        this.tempDirectory = Files.createTempDirectory("elasticsearch", new FileAttribute[0]);
        this.embeddedElasticSearch = new EmbeddedElasticSearch(this.tempDirectory, MailboxElasticSearchConstants.DEFAULT_MAILBOX_INDEX);
        this.embeddedElasticSearch.before();
        this.initFields();
    }

    public void afterTest() throws Exception {
        this.embeddedElasticSearch.after();
        FileUtils.deleteDirectory((File)this.tempDirectory.toFile());
    }

    private void initFields() throws MailboxException {
        Client client = MailboxIndexCreationUtil.prepareDefaultClient((Client)new TestingClientProvider(this.embeddedElasticSearch.getNode()).get());
        InMemoryMailboxSessionMapperFactory factory = new InMemoryMailboxSessionMapperFactory();
        InMemoryMessageId.Factory messageIdFactory = new InMemoryMessageId.Factory();
        ElasticSearchListeningMessageSearchIndex searchIndex = new ElasticSearchListeningMessageSearchIndex((MessageMapperFactory)factory, new ElasticSearchIndexer(client, Executors.newSingleThreadExecutor(), MailboxElasticSearchConstants.DEFAULT_MAILBOX_WRITE_ALIAS, MailboxElasticSearchConstants.MESSAGE_TYPE), new ElasticSearchSearcher(client, new QueryConverter(new CriterionConverter()), 100, (MailboxId.Factory)new InMemoryId.Factory(), (MessageId.Factory)messageIdFactory, MailboxElasticSearchConstants.DEFAULT_MAILBOX_READ_ALIAS, MailboxElasticSearchConstants.MESSAGE_TYPE), new MessageToElasticSearchJson((TextExtractor)new DefaultTextExtractor(), ZoneId.systemDefault(), IndexAttachments.YES));
        this.mailboxManager = new InMemoryIntegrationResources().createMailboxManager((GroupMembershipResolver)new SimpleGroupMembershipResolver(), this.authenticator, this.authorizator);
        this.mailboxManager.setMessageSearchIndex((MessageSearchIndex)searchIndex);
        this.mailboxManager.addGlobalListener((MailboxListener)searchIndex, (MailboxSession)new MockMailboxSession("admin"));
        ImapProcessor defaultImapProcessorFactory = DefaultImapProcessorFactory.createDefaultProcessor((MailboxManager)this.mailboxManager, (SubscriptionManager)new StoreSubscriptionManager((SubscriptionMapperFactory)factory), (QuotaManager)new NoQuotaManager(), (QuotaRootResolver)new DefaultUserQuotaRootResolver((MailboxSessionMapperFactory)factory), (MetricFactory)new DefaultMetricFactory());
        this.configure(new DefaultImapDecoderFactory().buildImapDecoder(), new DefaultImapEncoderFactory().buildImapEncoder(), defaultImapProcessorFactory);
        this.embeddedElasticSearch.awaitForElasticSearch();
    }

    protected MailboxManager getMailboxManager() {
        return this.mailboxManager;
    }

    public boolean supports(ImapFeatures.Feature ... features) {
        return SUPPORTED_FEATURES.supports(features);
    }

    public void setQuotaLimits(QuotaCount maxMessageQuota, QuotaSize maxStorageQuota) throws Exception {
        throw new NotImplementedException();
    }
}

