/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.mpt.imapmailbox.suite;

import java.util.Locale;

import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mpt.api.ImapHostSystem;
import org.apache.james.mpt.imapmailbox.ImapTestConstants;
import org.apache.james.mpt.imapmailbox.suite.base.BasicImapCommands;
import org.apache.james.mpt.script.ImapScriptedTestProtocol;
import org.junit.Before;
import org.junit.Test;

public abstract class AuthenticatePlain implements ImapTestConstants {
    
    protected abstract ImapHostSystem createImapHostSystem();
    
    private ImapHostSystem system;
    private ImapScriptedTestProtocol simpleScriptedTestProtocol;

    @Before
    public void setUp() throws Exception {
        system = createImapHostSystem();
        simpleScriptedTestProtocol = new ImapScriptedTestProtocol("/org/apache/james/imap/scripts/", system)
                .withUser(USER, PASSWORD)
                .withUser("delegate", "123456")
                .withMailbox(MailboxPath.forUser(Username.of("delegate"), "delegate"))
                .withMailbox(MailboxPath.forUser(Username.of("imapuser"), "imapuser"));
        BasicImapCommands.welcome(simpleScriptedTestProtocol);
    }
    
    @Test
    public void testAuthenticatePlainUS() throws Exception {
        simpleScriptedTestProtocol
            .withLocale(Locale.US)
            .run("AuthenticatePlain");
    }

    @Test
    public void testAuthenticatePlainITALY() throws Exception {
        simpleScriptedTestProtocol
            .withLocale(Locale.ITALY)
            .run("AuthenticatePlain");
    }

    @Test
    public void testAuthenticatePlainKOREA() throws Exception {
        simpleScriptedTestProtocol
            .withLocale(Locale.KOREA)
            .run("AuthenticatePlain");
    }
}
